/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.item.dao.impl;

import cn.com.duiba.service.dao.BaseDao;
import cn.com.duiba.service.dao.DatabaseSchema;
import cn.com.duiba.service.domain.dataobject.AppItemDO;
import cn.com.duiba.service.item.dao.AppItemClassifyDao;
import cn.com.duiba.service.item.domain.dataobject.AppItemClassifyDO;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;

@Repository
public class AppItemClassifyDaoImpl
extends BaseDao
implements AppItemClassifyDao {
    @Override
    public Long findByCount(Map<String, Object> params) {
        return (Long)this.selectOne("findByCount", params);
    }

    @Override
    public List<AppItemClassifyDO> findByLimit(Map<String, Object> params) {
        return this.selectList("findByLimit", params);
    }

    @Override
    public List<AppItemClassifyDO> findAllByAppId(Long appId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("appId", appId);
        return this.selectList("findAllByAppId", map);
    }

    @Override
    public int batchInsert(List<Map<String, Object>> classifyRelation) {
        HashMap<String, List<Map<String, Object>>> map = new HashMap<String, List<Map<String, Object>>>();
        map.put("relationList", classifyRelation);
        return this.insert("batchInsert", map);
    }

    @Override
    public List<Long> findAllAppItemById(Long classifyId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("classifyId", classifyId);
        return this.selectList("findAllAppItemById", map);
    }

    @Override
    public int deleteAppItemRelation(List<Long> ids, Long appId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appId", appId);
        map.put("ids", ids);
        return this.delete("deleteAppItemRelation", map);
    }

    @Override
    public void insert(AppItemClassifyDO appItemClassifyDO) {
        this.insert("insert", appItemClassifyDO);
    }

    @Override
    public AppItemClassifyDO find(Long id) {
        return (AppItemClassifyDO)this.selectOne("find", id);
    }

    @Override
    public void update(AppItemClassifyDO appItemClassifyDO) {
        this.update("update", appItemClassifyDO);
    }

    @Override
    public int deleteClassifyAppItem(Long classifyId, Long appItemId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("classifyId", classifyId);
        map.put("appItemId", appItemId);
        return this.delete("deleteClassifyAppItem", map);
    }

    @Override
    public List<AppItemDO> findClassifyAppItems(Long classifyId, Long appId, String status, Integer start, Integer pageSize) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("classifyId", classifyId);
        map.put("appId", appId);
        map.put("status", status);
        map.put("start", start);
        map.put("pageSize", pageSize);
        return this.selectList("findClassifyAppItems", map);
    }

    @Override
    public List<AppItemDO> findAppItemNoExistClassify(Map<String, Object> query, Integer start, Integer pageSize) {
        query.put("start", start);
        query.put("pageSize", pageSize);
        return this.selectList("findAppItemNoExistClassify", query);
    }

    @Override
    public Integer deleteClassifyAllAppItem(Long classifyId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("classifyId", classifyId);
        return this.delete("deleteClassifyAllAppItem", map);
    }

    @Override
    public Integer deleteRelationAppItem(Long appItemId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("appItemId", appItemId);
        return this.delete("deleteRelationAppItem", map);
    }

    @Override
    public Integer findMaxPayload(Long classifyId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("classifyId", classifyId);
        return (Integer)this.selectOne("findMaxPayload", map);
    }

    @Override
    public Integer updatePayload(Long appItemId, Long classifyId, Integer payload) {
        HashMap<String, Number> map = new HashMap<String, Number>();
        map.put("appItemId", appItemId);
        map.put("classifyId", classifyId);
        map.put("payload", payload);
        return this.update("updatePayload", map);
    }

    @Override
    public List<AppItemClassifyDO> findByIds(List<Long> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, List<Long>> map = new HashMap<String, List<Long>>();
        map.put("ids", ids);
        return this.selectList("findByIds", map);
    }

    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CREDITS;
    }
}

