/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.item.remoteservice.impl;

import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.service.domain.dataobject.PreStockDO;
import cn.com.duiba.service.domain.dataobject.PreStockPointDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.service.exception.StatusException;
import cn.com.duiba.service.item.bo.CreditsCalculateBo;
import cn.com.duiba.service.item.bo.PreStockBo;
import cn.com.duiba.service.remoteservice.RemotePreStockService;
import cn.com.duiba.service.service.PreStockService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class RemotePreStockServiceImpl
implements RemotePreStockService {
    @Resource
    private PreStockService preStockService;
    @Resource
    private PreStockBo preStockBo;
    @Resource
    private CreditsCalculateBo creditsCalculateBo;

    public PreStockDO findByPointId(Long pointId) {
        return this.preStockService.findByPointId(pointId);
    }

    public PreStockDO newStock(PreStockDO stock) {
        return this.preStockService.newStock(stock);
    }

    public boolean addQuantity(Long stockId, long quantity) {
        return this.preStockService.addQuantity(stockId, quantity);
    }

    public boolean reduceQuantity(Long stockId, long quantity) {
        return this.preStockService.reduceQuantity(stockId, quantity);
    }

    public PreStockDO lock4update(Long stockId) {
        return this.preStockService.lock4update(stockId);
    }

    public List<PreStockDO> findAllByPointIds(List<Long> pointIds) {
        return this.preStockService.findAllByPointIds(pointIds);
    }

    public void consumeStock(String bizId, Long appId, Long pointId) throws BusinessException, StatusException {
        this.preStockBo.consumeStock(bizId, appId, pointId);
    }

    public void paybackStock(String bizId) throws BusinessException {
        this.preStockBo.paybackStock(bizId);
    }

    public Integer getMinExchangePrice(ItemDO item, AppDO app) {
        return this.preStockBo.getMinExchangePrice(item, app);
    }

    public Long getPreStock(ItemDO item, AppDO app) {
        return this.preStockBo.getPreStock(item, app);
    }

    public Integer getPreStockQuantitySales(ItemKey itemKey) {
        return this.preStockBo.getPreStockQuantitySales(itemKey);
    }

    public boolean chargeMode(String chargeMode) {
        return this.preStockBo.chargeMode(chargeMode);
    }

    public PreStockPointDO getPointStock(ItemDO item, AppDO app) {
        return this.preStockBo.getPointStock(item, app);
    }

    public Long calculateCreditsByItemKeyAndDegree(ItemKey key, String degree) {
        return this.creditsCalculateBo.calculateCreditsByItemKeyAndDegree(key, degree);
    }
}

