/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.item.service.impl;

import cn.com.duiba.service.domain.dataobject.AppItemDO;
import cn.com.duiba.service.item.dao.AppItemClassifyDao;
import cn.com.duiba.service.item.domain.dataobject.AppItemClassifyDO;
import cn.com.duiba.service.item.service.AppItemClassifyService;
import cn.com.duiba.wolf.cache.CacheClient;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class AppItemClassifyServiceImpl
implements AppItemClassifyService {
    @Resource
    private AppItemClassifyDao appItemClassifyDao;
    @Resource
    private CacheClient cacheClient;

    private String getCacheKeyById(Long id) {
        return "item.appItemClassifyById_" + id;
    }

    @Override
    public Long findByCount(Map<String, Object> params) {
        return this.appItemClassifyDao.findByCount(params);
    }

    @Override
    public List<AppItemClassifyDO> findByLimit(Map<String, Object> params) {
        return this.appItemClassifyDao.findByLimit(params);
    }

    @Override
    public List<AppItemClassifyDO> findAllByAppId(Long appId) {
        return this.appItemClassifyDao.findAllByAppId(appId);
    }

    @Override
    public int batchInsert(List<Map<String, Object>> classifyRelation) {
        return this.appItemClassifyDao.batchInsert(classifyRelation);
    }

    @Override
    public List<Long> findAllAppItemById(Long classifyId) {
        return this.appItemClassifyDao.findAllAppItemById(classifyId);
    }

    @Override
    public int deleteAppItemRelation(List<Long> ids, Long appId) {
        return this.appItemClassifyDao.deleteAppItemRelation(ids, appId);
    }

    @Override
    public void insert(AppItemClassifyDO appItemClassifyDO) {
        this.appItemClassifyDao.insert(appItemClassifyDO);
    }

    @Override
    public AppItemClassifyDO find(Long id) {
        String key = this.getCacheKeyById(id);
        AppItemClassifyDO d = (AppItemClassifyDO)this.cacheClient.get(key);
        if (d == null) {
            d = this.appItemClassifyDao.find(id);
            this.cacheClient.set(key, (Object)d, 10, TimeUnit.MINUTES);
        }
        return d;
    }

    @Override
    public void update(AppItemClassifyDO appItemClassifyDO) {
        this.appItemClassifyDao.update(appItemClassifyDO);
        this.cacheClient.remove(this.getCacheKeyById(appItemClassifyDO.getId()));
    }

    @Override
    public int deleteClassifyAppItem(Long classifyId, Long appItemId) {
        return this.appItemClassifyDao.deleteClassifyAppItem(classifyId, appItemId);
    }

    @Override
    public List<AppItemDO> findClassifyAppItems(Long classifyId, Long appId, String status, Integer start, Integer pageSize) {
        return this.appItemClassifyDao.findClassifyAppItems(classifyId, appId, status, start, pageSize);
    }

    @Override
    public List<AppItemDO> findAppItemNoExistClassify(Map<String, Object> query, Integer start, Integer pageSize) {
        return this.appItemClassifyDao.findAppItemNoExistClassify(query, start, pageSize);
    }

    @Override
    public Integer deleteClassifyAllAppItem(Long classifyId) {
        return this.appItemClassifyDao.deleteClassifyAllAppItem(classifyId);
    }

    @Override
    public Integer deleteRelationAppItem(Long appItemId) {
        return this.appItemClassifyDao.deleteRelationAppItem(appItemId);
    }

    @Override
    public Integer findMaxPayload(Long classifyId) {
        return this.appItemClassifyDao.findMaxPayload(classifyId);
    }

    @Override
    public Integer updatePayload(Long appItemId, Long classifyId, Integer payload) {
        return this.appItemClassifyDao.updatePayload(appItemId, classifyId, payload);
    }

    @Override
    public List<AppItemClassifyDO> findByIds(List<Long> ids) {
        return this.appItemClassifyDao.findByIds(ids);
    }
}

