/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.item.service.impl;

import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.domain.dataobject.AppItemDO;
import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.item.service.AppItemService;
import cn.com.duiba.service.item.service.ItemKeyService;
import cn.com.duiba.service.item.service.ItemService;
import cn.com.duiba.service.service.AppService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ItemKeyServiceImpl
implements ItemKeyService {
    @Autowired
    private ItemService itemService;
    @Autowired
    private AppItemService appItemService;
    @Autowired
    private AppService appService;

    @Override
    public ItemKey getItemKey(Long itemId, Long appItemId, Long appId) {
        return this.getItemKey(itemId, appItemId, appId, false);
    }

    private ItemKey getItemKey(Long itemId, Long appItemId, Long appId, boolean includeDeleted) {
        AppDO app = this.appService.find(appId);
        return this.getItemKey(itemId, appItemId, app, includeDeleted);
    }

    @Override
    public ItemKey getItemKey(Long itemId, Long appItemId, AppDO app) {
        return this.getItemKey(itemId, appItemId, app, false);
    }

    private ItemKey getItemKey(Long itemId, Long appItemId, AppDO app, boolean includeDeleted) {
        ItemDO item = null;
        AppItemDO appItem = null;
        if (appItemId != null) {
            appItem = this.appItemService.find(appItemId);
            if (appItem.getItemId() != null) {
                item = this.itemService.find(appItem.getItemId());
            }
        } else if (itemId != null) {
            item = this.itemService.find(itemId);
            appItem = this.appItemService.findByAppIdAndItemId(app.getId(), itemId);
        }
        if (!includeDeleted && appItem != null && appItem.getDeleted().booleanValue()) {
            appItem = null;
        }
        return ItemKey.generate((ItemDO)item, (AppItemDO)appItem, (AppDO)app);
    }

    @Override
    public ItemKey getItemKeyIncludeDeleted(Long itemId, Long appItemId, Long appId) {
        return this.getItemKey(itemId, appItemId, appId, true);
    }

    @Override
    public ItemKey getItemKeyIncludeDeleted(Long itemId, Long appItemId, AppDO app) {
        return this.getItemKey(itemId, appItemId, app, true);
    }

    @Override
    public List<ItemKey> getBatchItemKeyByAppItem(List<AppItemDO> appItems, AppDO app) {
        ArrayList<Long> itemIds = new ArrayList<Long>();
        for (AppItemDO ai : appItems) {
            if (ai.getItemId() == null) continue;
            itemIds.add(ai.getItemId());
        }
        ArrayList<ItemKey> itemKeyList = new ArrayList<ItemKey>();
        if (itemIds.size() > 0) {
            List<ItemDO> items = this.itemService.findAllByIds(itemIds);
            HashMap<Long, ItemDO> itemMap = new HashMap<Long, ItemDO>();
            for (ItemDO item : items) {
                itemMap.put(item.getId(), item);
            }
            for (AppItemDO ai : appItems) {
                ItemDO item = null;
                if (ai.getItemId() != null) {
                    item = (ItemDO)itemMap.get(ai.getItemId());
                }
                itemKeyList.add(ItemKey.generate(item, (AppItemDO)ai, (AppDO)app));
            }
        } else {
            for (AppItemDO ai : appItems) {
                itemKeyList.add(ItemKey.generate(null, (AppItemDO)ai, (AppDO)app));
            }
        }
        return itemKeyList;
    }

    @Override
    public ItemKey getItemKey(ItemDO item, AppItemDO appItem, AppDO app) {
        return ItemKey.generate((ItemDO)item, (AppItemDO)appItem, (AppDO)app);
    }
}

