/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.item.service.impl;

import cn.com.duiba.service.domain.dataobject.AppItemDO;
import cn.com.duiba.service.domain.dataobject.CouponBatchDO;
import cn.com.duiba.service.domain.dataobject.CouponDO;
import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.service.exception.StatusException;
import cn.com.duiba.service.item.domain.vo.CouponImportResult;
import cn.com.duiba.service.item.service.AppItemService;
import cn.com.duiba.service.item.service.CouponBatchService;
import cn.com.duiba.service.item.service.CouponFlowInnerService;
import cn.com.duiba.service.item.service.CouponService;
import cn.com.duiba.service.item.service.ItemService;
import cn.com.duiba.service.item.tools.AnalysisCoupon;
import cn.com.duiba.wolf.utils.DateUtils;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CouponFlowInnerServiceImpl
implements CouponFlowInnerService {
    @Autowired
    private CouponBatchService couponBatchService;
    @Autowired
    private CouponService couponService;
    @Autowired
    private ItemService itemService;
    @Autowired
    private AppItemService appItemService;

    @Override
    public CouponBatchDO checkCouponBatch(ItemKey itemKey) throws StatusException {
        CouponBatchDO couponBatch = this.getItemKeyCurrentCouponBatch(itemKey);
        if (couponBatch == null) {
            throw new StatusException(0, "\u5151\u6362\u52b5\u5df2\u7ecf\u7528\u5b8c");
        }
        if (couponBatch.getRemaining() <= 0) {
            throw new StatusException(0, "\u5151\u6362\u52b5\u5df2\u7ecf\u7528\u5b8c");
        }
        return couponBatch;
    }

    @Override
    public CouponBatchDO getItemKeyCurrentCouponBatch(ItemKey itemKey) {
        Long batchId = null;
        if (itemKey.isItemMode()) {
            batchId = itemKey.getItem().getBatchId();
        } else if (itemKey.isDuibaAppItemMode()) {
            batchId = itemKey.getItem().getBatchId();
        } else if (itemKey.isSelfAppItemMode()) {
            batchId = itemKey.getAppItem().getBatchId();
        }
        CouponBatchDO couponBatch = null;
        if (batchId != null) {
            couponBatch = this.couponBatchService.find(batchId);
        }
        return couponBatch;
    }

    @Override
    @Transactional(value="credits", propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void switchBatch(ItemKey itemKey) {
        if (itemKey.isItemMode()) {
            this.switchItemBatch(itemKey.getItem().getId());
        } else if (itemKey.isDuibaAppItemMode()) {
            this.switchItemBatch(itemKey.getItem().getId());
        } else if (itemKey.isSelfAppItemMode()) {
            this.switchAppItemBatch(itemKey.getAppItem().getId());
        }
    }

    @Override
    @Transactional(value="credits", propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void switchItemBatch(long itemId) {
        ItemDO item = this.itemService.find(itemId);
        if (item == null) {
            return;
        }
        if (!"coupon".equals(item.getType())) {
            return;
        }
        CouponBatchDO nextBatch = null;
        if (item.getBatchId() != null) {
            CouponBatchDO currentBatch = this.couponBatchService.find(item.getBatchId());
            if (currentBatch.getRemaining() > 0 && currentBatch.getValidEndDate().after(new Date())) {
                return;
            }
            this.refreshBatch(currentBatch);
            this.couponBatchService.setItemBatchEmpty(itemId);
            nextBatch = this.couponBatchService.findItemNextBatch(itemId);
        } else {
            nextBatch = this.couponBatchService.findItemNextBatch(itemId);
        }
        if (nextBatch != null) {
            Integer remaining = this.couponBatchService.countBatchRemaining(nextBatch.getId());
            this.couponBatchService.updateActiveAndRemaining(nextBatch.getId(), 1, remaining);
            this.itemService.updateBatchIdById(itemId, nextBatch.getId());
        }
    }

    @Override
    @Transactional(value="credits", propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void switchAppItemBatch(long appItemId) {
        AppItemDO appItem = this.appItemService.find(appItemId);
        if (appItem == null) {
            return;
        }
        if (!"coupon".equals(appItem.getType())) {
            return;
        }
        CouponBatchDO nextBatch = null;
        if (appItem.getBatchId() != null) {
            CouponBatchDO currentBatch = this.couponBatchService.find(appItem.getBatchId());
            if (currentBatch.getRemaining() > 0 && currentBatch.getValidEndDate().after(new Date())) {
                return;
            }
            this.refreshBatch(currentBatch);
            this.couponBatchService.setAppItemBatchEmpty(appItemId);
            nextBatch = this.couponBatchService.findAppItemNextBatch(appItemId);
        } else {
            nextBatch = this.couponBatchService.findAppItemNextBatch(appItemId);
        }
        if (nextBatch != null) {
            Integer remaining = this.couponBatchService.countBatchRemaining(nextBatch.getId());
            this.couponBatchService.updateActiveAndRemaining(nextBatch.getId(), 1, remaining);
            this.appItemService.updateBatchIdById(appItemId, nextBatch.getId());
        }
    }

    @Override
    @Transactional(value="credits", propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void refreshBatch(CouponBatchDO batch) {
        Integer active = batch.getActive();
        if (batch.getValidEndDate().before(new Date())) {
            active = 3;
        }
        Integer remaining = this.couponBatchService.countBatchRemaining(batch.getId());
        if (2 == batch.getActive() && remaining > 0) {
            active = 0;
        }
        if (remaining <= 0) {
            Integer ret = this.couponService.ishavingCoupon(batch.getId());
            active = ret == null ? Integer.valueOf(4) : Integer.valueOf(2);
        }
        this.couponBatchService.updateActiveAndRemaining(batch.getId(), active, remaining);
    }

    @Override
    @Transactional(value="credits", propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void refreshItemKeyCoupon(ItemKey itemKey) {
        if (itemKey.isItemMode()) {
            this.refreshItemCoupon(itemKey.getItem().getId());
        } else if (itemKey.isDuibaAppItemMode()) {
            this.refreshItemCoupon(itemKey.getItem().getId());
        } else if (itemKey.isSelfAppItemMode()) {
            this.refreshAppItemCoupon(itemKey.getAppItem().getId());
        }
    }

    @Override
    @Transactional(value="credits", propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void refreshItemCoupon(long itemId) {
        ItemDO item = this.itemService.find(itemId);
        if (item == null) {
            return;
        }
        if (!"coupon".equals(item.getType())) {
            return;
        }
        CouponBatchDO batch = this.couponBatchService.findItemMaxValidEndDateBatch(itemId);
        Date validEndDate = item.getValidEndDate();
        if (batch != null) {
            validEndDate = batch.getValidEndDate();
            if (batch.getValidEndDate().after(new Date())) {
                this.appItemService.updateExpiedAppItem(itemId);
            }
        }
        Integer totalRemaining = this.couponBatchService.countAllRemaining(null, itemId);
        this.itemService.updateRemainingAndvalidEndDate(itemId, totalRemaining, validEndDate);
    }

    @Override
    @Transactional(value="credits", propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void refreshAppItemCoupon(long appItemId) {
        AppItemDO appItem = this.appItemService.find(appItemId);
        if (appItem == null) {
            return;
        }
        if (!"coupon".equals(appItem.getType())) {
            return;
        }
        CouponBatchDO batch = this.couponBatchService.findAppItemMaxValidEndDateBatch(appItemId);
        Date validEndDate = appItem.getValidEndDate();
        if (batch != null) {
            validEndDate = batch.getValidEndDate();
            if (batch.getValidEndDate().after(new Date())) {
                this.appItemService.updateExpiedAppItemById(appItemId);
            }
        }
        Integer totalRemaining = this.couponBatchService.countAllRemaining(appItemId, null);
        this.appItemService.updateRemainingAndvalidEndDate(appItemId, totalRemaining, validEndDate);
    }

    private CouponBatchDO createItemBatch(Long itemId, Long batchId, Date startTime, Date endTime) throws StatusException, BusinessException {
        CouponBatchDO importBatch = null;
        if (batchId != null) {
            importBatch = this.couponBatchService.find(batchId);
            if (importBatch != null && 2 == importBatch.getActive() && importBatch.getValidEndDate().after(new Date())) {
                this.couponBatchService.updateActive(batchId, 0);
                importBatch.setActive(Integer.valueOf(0));
            }
        } else {
            Date validStartDate = DateUtils.getSecondDate((String)(String.valueOf(DateUtils.getDayStr((Date)startTime)) + " 00:00:00"));
            Date validEndDate = DateUtils.getSecondDate((String)(String.valueOf(DateUtils.getDayStr((Date)endTime)) + " 23:59:59"));
            Date today = DateUtils.getDayDate((Date)new Date());
            if (validStartDate.before(today)) {
                throw new StatusException(0, "\u8d77\u59cb\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u4eca\u5929");
            }
            if (validStartDate.after(validEndDate)) {
                throw new StatusException(0, "\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u5f00\u59cb\u65e5\u671f");
            }
            importBatch = this.couponBatchService.findItemBatchByValidStartDateAndValidEndDate(itemId, validStartDate, validEndDate);
            if (importBatch == null) {
                importBatch = new CouponBatchDO(true);
                importBatch.setItemId(itemId);
                importBatch.setActive(Integer.valueOf(0));
                importBatch.setRemaining(Integer.valueOf(0));
                importBatch.setValidStartDate(validStartDate);
                importBatch.setValidEndDate(validEndDate);
                this.couponBatchService.insert(importBatch);
            } else if ((2 == importBatch.getActive() || 3 == importBatch.getActive() || 4 == importBatch.getActive()) && importBatch.getValidEndDate().after(new Date())) {
                importBatch.setActive(Integer.valueOf(0));
                this.couponBatchService.updateActive(importBatch.getId(), 0);
            }
        }
        if (importBatch == null) {
            throw new BusinessException("\u5bfc\u5165\u6279\u6b21\u5931\u8d25");
        }
        return importBatch;
    }

    private CouponBatchDO createAppItemBatch(Long appItemId, Long batchId, Date startTime, Date endTime) throws StatusException, BusinessException {
        CouponBatchDO importBatch = null;
        if (batchId != null) {
            importBatch = this.couponBatchService.findForUpdate(batchId);
            if (importBatch != null && 2 == importBatch.getActive() && importBatch.getValidEndDate().after(new Date())) {
                this.couponBatchService.updateActive(batchId, 0);
                importBatch.setActive(Integer.valueOf(0));
            }
        } else {
            Date validStartDate = DateUtils.getSecondDate((String)(String.valueOf(DateUtils.getDayStr((Date)startTime)) + " 00:00:00"));
            Date validEndDate = DateUtils.getSecondDate((String)(String.valueOf(DateUtils.getDayStr((Date)endTime)) + " 23:59:59"));
            Date today = DateUtils.getDayDate((Date)new Date());
            if (validStartDate.before(today)) {
                throw new StatusException(0, "\u8d77\u59cb\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u4eca\u5929");
            }
            if (validStartDate.after(validEndDate)) {
                throw new StatusException(0, "\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u5f00\u59cb\u65e5\u671f");
            }
            importBatch = this.couponBatchService.findAppItemBatchByValidStartDateAndValidEndDate(appItemId, validStartDate, validEndDate);
            if (importBatch == null) {
                importBatch = new CouponBatchDO(true);
                importBatch.setAppItemId(appItemId);
                importBatch.setActive(Integer.valueOf(0));
                importBatch.setRemaining(Integer.valueOf(0));
                importBatch.setValidStartDate(validStartDate);
                importBatch.setValidEndDate(validEndDate);
                this.couponBatchService.insert(importBatch);
            } else if ((2 == importBatch.getActive() || 3 == importBatch.getActive() || 4 == importBatch.getActive()) && importBatch.getValidEndDate().after(new Date())) {
                importBatch.setActive(Integer.valueOf(0));
                this.couponBatchService.updateActive(importBatch.getId(), 0);
            }
        }
        if (importBatch == null) {
            throw new BusinessException("\u5bfc\u5165\u6279\u6b21\u5931\u8d25");
        }
        return importBatch;
    }

    @Override
    @Transactional(value="credits", propagation=Propagation.REQUIRED)
    public CouponImportResult importItemCouponNormal(long itemId, Long batchId, Date startTime, Date endTime, String fileUrl, String fileType) throws BusinessException, StatusException {
        AnalysisCoupon<CouponDO> analysis = new AnalysisCoupon<CouponDO>(fileUrl, fileType, new Function<List<String>, CouponDO>(){

            public CouponDO apply(List<String> arg0) {
                CouponDO coupon = new CouponDO();
                coupon.setCode(arg0.get(0));
                if (arg0.size() == 2) {
                    coupon.setPassword(arg0.get(1));
                }
                return coupon;
            }
        });
        ItemDO item = this.itemService.find(itemId);
        if (item.getSubType() == null) {
            this.itemService.updateSubTypeById(itemId, 0);
        } else if (!Objects.equal((Object)item.getSubType(), (Object)0)) {
            throw new BusinessException("\u8be5\u4f18\u60e0\u5238\u4e0d\u662f\u666e\u901a\u5238\u7c7b\u578b");
        }
        CouponBatchDO couponBatch = this.createItemBatch(itemId, batchId, startTime, endTime);
        int count = 0;
        if (analysis.hasNext()) {
            this.itemService.findForUpdate(itemId);
            couponBatch = this.couponBatchService.findForUpdate(couponBatch.getId());
            int temp = 0;
            while (analysis.hasNext()) {
                ArrayList list = Lists.newArrayList();
                while (analysis.hasNext() && temp <= 1000) {
                    CouponDO impCoupon = analysis.next();
                    CouponDO coupon = new CouponDO(true);
                    coupon.setBatchId(couponBatch.getId());
                    coupon.setItemId(couponBatch.getItemId());
                    coupon.setAppItemId(couponBatch.getAppItemId());
                    coupon.setCode(impCoupon.getCode());
                    coupon.setPassword(impCoupon.getPassword());
                    coupon.setLocked(Boolean.valueOf(false));
                    coupon.setUsed(Boolean.valueOf(false));
                    list.add(coupon);
                    ++temp;
                }
                this.couponService.batchInsertCoupon(list);
                count += temp;
                temp = 0;
            }
            this.refreshBatch(couponBatch);
            this.switchItemBatch(itemId);
            this.refreshItemCoupon(itemId);
        }
        CouponImportResult r = new CouponImportResult();
        r.setCouponCount(count);
        r.setFileLines(analysis.getTotal());
        return r;
    }

    @Override
    @Transactional(value="credits", propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public int importItemCouponRepeat(long itemId, Long batchId, Date startTime, Date endTime, String code, String password, int instock) throws StatusException, BusinessException {
        ItemDO item = this.itemService.find(itemId);
        if (item.getSubType() == null) {
            this.itemService.updateSubTypeById(itemId, 2);
        } else if (!Objects.equal((Object)item.getSubType(), (Object)2)) {
            throw new BusinessException("\u8be5\u4f18\u60e0\u5238\u4e0d\u662f\u91cd\u590d\u5238\u7c7b\u578b");
        }
        CouponBatchDO couponBatch = this.createItemBatch(itemId, batchId, startTime, endTime);
        int count = 0;
        if (instock > 0) {
            this.itemService.findForUpdate(itemId);
            couponBatch = this.couponBatchService.findForUpdate(couponBatch.getId());
            int temp = 0;
            while (count < instock) {
                ArrayList<CouponDO> impCoupons = new ArrayList<CouponDO>();
                while (count < instock && temp < 1000) {
                    CouponDO coupon = new CouponDO(true);
                    coupon.setBatchId(couponBatch.getId());
                    coupon.setItemId(couponBatch.getItemId());
                    coupon.setAppItemId(couponBatch.getAppItemId());
                    coupon.setLocked(Boolean.valueOf(false));
                    coupon.setUsed(Boolean.valueOf(false));
                    coupon.setCode(code);
                    coupon.setPassword(password);
                    impCoupons.add(coupon);
                    ++count;
                    ++temp;
                }
                this.couponService.batchInsertCoupon(impCoupons);
                temp = 0;
            }
            this.refreshBatch(couponBatch);
            this.switchItemBatch(itemId);
            this.refreshItemCoupon(itemId);
        }
        return count;
    }

    @Override
    @Transactional(value="credits", propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public int importItemCouponLink(long itemId, Long batchId, Date startTime, Date endTime, String link, String showText, int instock) throws BusinessException, StatusException {
        ItemDO item = this.itemService.find(itemId);
        if (item.getSubType() == null) {
            this.itemService.updateSubTypeById(itemId, 1);
        } else if (!Objects.equal((Object)item.getSubType(), (Object)1)) {
            throw new BusinessException("\u8be5\u4f18\u60e0\u5238\u4e0d\u662f\u94fe\u63a5\u5238\u7c7b\u578b");
        }
        CouponBatchDO couponBatch = this.createItemBatch(itemId, batchId, startTime, endTime);
        int count = 0;
        if (instock > 0) {
            this.itemService.findForUpdate(itemId);
            couponBatch = this.couponBatchService.findForUpdate(couponBatch.getId());
            int temp = 0;
            while (count < instock) {
                ArrayList<CouponDO> impCoupons = new ArrayList<CouponDO>();
                while (count < instock && temp < 1000) {
                    CouponDO coupon = new CouponDO(true);
                    coupon.setBatchId(couponBatch.getId());
                    coupon.setItemId(couponBatch.getItemId());
                    coupon.setAppItemId(couponBatch.getAppItemId());
                    coupon.setLocked(Boolean.valueOf(false));
                    coupon.setUsed(Boolean.valueOf(false));
                    coupon.setCode(link);
                    coupon.setPassword(showText);
                    impCoupons.add(coupon);
                    ++count;
                    ++temp;
                }
                this.couponService.batchInsertCoupon(impCoupons);
                temp = 0;
            }
            this.refreshBatch(couponBatch);
            this.switchItemBatch(itemId);
            this.refreshItemCoupon(itemId);
        }
        return count;
    }

    @Override
    @Transactional(value="credits", propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public int importAppItemCouponNormal(long appItemId, Long batchId, Date startTime, Date endTime, List<CouponDO> coupons) throws BusinessException, StatusException {
        AppItemDO appItem = this.appItemService.findForUpdate(appItemId);
        if (Objects.equal(null, (Object)appItem) || !Objects.equal((Object)"coupon", (Object)appItem.getType())) {
            throw new BusinessException("\u5546\u54c1\u9879\u65e0\u6548");
        }
        if (!Objects.equal(null, (Object)appItem.getSubType()) && !Objects.equal((Object)0, (Object)appItem.getSubType())) {
            throw new BusinessException("\u4f18\u60e0\u4e0d\u662f\u666e\u901a\u5238\u7c7b\u578b\uff0c\u4e0d\u80fd\u5411\u5176\u4e2d\u5bfc\u5165\u666e\u901a\u5238");
        }
        if (appItem.getSubType() == null) {
            this.appItemService.updateSubTypeById(appItemId, 0);
        }
        CouponBatchDO couponBatch = this.createAppItemBatch(appItemId, batchId, startTime, endTime);
        ArrayList<CouponDO> impCoupons = new ArrayList<CouponDO>();
        for (CouponDO impCoupon : coupons) {
            CouponDO coupon = new CouponDO(true);
            coupon.setBatchId(couponBatch.getId());
            coupon.setItemId(couponBatch.getItemId());
            coupon.setAppItemId(couponBatch.getAppItemId());
            coupon.setCode(impCoupon.getCode());
            coupon.setPassword(impCoupon.getPassword());
            coupon.setLocked(Boolean.valueOf(false));
            coupon.setUsed(Boolean.valueOf(false));
            impCoupons.add(coupon);
        }
        if (impCoupons.size() > 0) {
            this.appItemService.findForUpdate(appItemId);
            couponBatch = this.couponBatchService.findForUpdate(couponBatch.getId());
            this.couponService.batchInsertCoupon(impCoupons);
            this.refreshBatch(couponBatch);
            this.switchAppItemBatch(appItemId);
            this.refreshAppItemCoupon(appItemId);
        }
        return impCoupons.size();
    }

    @Override
    @Transactional(value="credits", propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public int importAppItemCouponRepeat(long appItemId, Long batchId, Date startTime, Date endTime, String code, String password, int instock, int maxLine) throws StatusException, BusinessException {
        AppItemDO appItem = this.appItemService.findForUpdate(appItemId);
        if (Objects.equal(null, (Object)appItem) || !Objects.equal((Object)"coupon", (Object)appItem.getType())) {
            throw new BusinessException("\u5546\u54c1\u9879\u65e0\u6548");
        }
        if (!Objects.equal(null, (Object)appItem.getSubType()) && !Objects.equal((Object)2, (Object)appItem.getSubType())) {
            throw new BusinessException("\u4f18\u60e0\u4e0d\u662f\u91cd\u590d\u5238\u7c7b\u578b");
        }
        int remaining = instock;
        if (remaining > maxLine) {
            throw new BusinessException("\u5355\u6b21\u5bfc\u5238\u6761\u6570\u4e0d\u80fd\u8d85\u8fc730000");
        }
        if (appItem.getSubType() == null) {
            appItem.setSubType(Integer.valueOf(2));
            this.appItemService.updateSubTypeById(appItemId, appItem.getSubType());
        }
        CouponBatchDO couponBatch = this.createAppItemBatch(appItemId, batchId, startTime, endTime);
        ArrayList<CouponDO> impCoupons = new ArrayList<CouponDO>();
        int i = 0;
        while (i < instock) {
            CouponDO coupon = new CouponDO(true);
            coupon.setBatchId(couponBatch.getId());
            coupon.setItemId(couponBatch.getItemId());
            coupon.setAppItemId(couponBatch.getAppItemId());
            coupon.setLocked(Boolean.valueOf(false));
            coupon.setUsed(Boolean.valueOf(false));
            coupon.setCode(code);
            coupon.setPassword(password);
            impCoupons.add(coupon);
            ++i;
        }
        if (impCoupons.size() > 0) {
            this.appItemService.findForUpdate(appItemId);
            couponBatch = this.couponBatchService.findForUpdate(couponBatch.getId());
            this.couponService.batchInsertCoupon(impCoupons);
            this.refreshBatch(couponBatch);
            this.switchAppItemBatch(appItemId);
            this.refreshAppItemCoupon(appItemId);
        }
        return impCoupons.size();
    }

    @Override
    @Transactional(value="credits", propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public int importAppItemCouponLink(long appItemId, Long batchId, Date startTime, Date endTime, String link, String showText, int instock, int maxLine) throws BusinessException, StatusException {
        AppItemDO appItem = this.appItemService.findForUpdate(appItemId);
        if (Objects.equal(null, (Object)appItem) || !Objects.equal((Object)"coupon", (Object)appItem.getType())) {
            throw new BusinessException("\u5546\u54c1\u9879\u65e0\u6548");
        }
        if (!Objects.equal(null, (Object)appItem.getSubType()) && !Objects.equal((Object)1, (Object)appItem.getSubType())) {
            throw new BusinessException("\u4f18\u60e0\u5238\u4e0d\u662f\u94fe\u63a5\u5238\u7c7b\u578b");
        }
        int remaining = instock;
        if (remaining > maxLine) {
            throw new BusinessException("\u5355\u6b21\u5bfc\u5238\u6761\u6570\u4e0d\u80fd\u8d85\u8fc730000");
        }
        if (appItem.getSubType() == null) {
            appItem.setSubType(Integer.valueOf(1));
            this.appItemService.updateSubTypeById(appItemId, appItem.getSubType());
        }
        CouponBatchDO couponBatch = this.createAppItemBatch(appItemId, batchId, startTime, endTime);
        ArrayList<CouponDO> impCoupons = new ArrayList<CouponDO>();
        int i = 0;
        while (i < instock) {
            CouponDO coupon = new CouponDO(true);
            coupon.setBatchId(couponBatch.getId());
            coupon.setItemId(couponBatch.getItemId());
            coupon.setAppItemId(couponBatch.getAppItemId());
            coupon.setLocked(Boolean.valueOf(false));
            coupon.setUsed(Boolean.valueOf(false));
            coupon.setCode(link);
            coupon.setPassword(showText);
            impCoupons.add(coupon);
            ++i;
        }
        if (impCoupons.size() > 0) {
            this.appItemService.findForUpdate(appItemId);
            couponBatch = this.couponBatchService.findForUpdate(couponBatch.getId());
            this.couponService.batchInsertCoupon(impCoupons);
            this.refreshBatch(couponBatch);
            this.switchAppItemBatch(appItemId);
            this.refreshAppItemCoupon(appItemId);
        }
        return impCoupons.size();
    }
}

