/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.item.bo.impl;

import cn.com.duiba.service.domain.dataobject.CouponDO;
import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.service.domain.dto.SellerDto;
import cn.com.duiba.service.item.bo.ImmediatelyButtonBackendBo;
import cn.com.duiba.service.item.service.CouponService;
import cn.com.duiba.service.item.service.ItemService;
import cn.com.duiba.service.item.service.SellerSevice;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.DateUtils;
import cn.com.duiba.wolf.utils.SecurityUtils;
import cn.com.duiba.wolf.utils.UrlUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ImmediatelyButtonBackendBoImpl
implements ImmediatelyButtonBackendBo {
    @Autowired
    private ItemService itemService;
    @Autowired
    private SellerSevice sellerSevice;
    @Autowired
    private CouponService couponService;

    @Override
    public DubboResult<String> selectImmediatelyButtonFromItem(Long itemId, Long orderId, String userAgent, String hdtoolFalg, String urlParameter, String embedClickurl) {
        if (itemId == null || orderId == null || userAgent == null || hdtoolFalg == null) {
            return DubboResult.failResult((String)("\u8f93\u5165\u53c2\u6570 \u4e0d\u80fd\u4e3a\u7a7aitemId\uff1a" + itemId + " orderId:" + orderId + " userAgent:" + userAgent + " hdtoolFalg:" + hdtoolFalg));
        }
        String returls = "";
        ItemDO item = this.itemService.find(itemId);
        if (item == null) {
            return DubboResult.failResult((String)("\u60a8\u8f93\u5165\u7684 itemId" + itemId + " \u672a\u67e5\u627e\u5230\u5bf9\u5e94\u7684 \u4f18\u60e0\u5238\u4fe1\u606f"));
        }
        returls = userAgent.contains("android") ? item.getAndroidDownload() : (item.getIosOpen() != null && item.getIosOpen().length() == 2 ? item.getIosDownload() : (item.getIosDownload() != null ? item.getIosDownload() : item.getIosOpen()));
        if (returls == null) {
            returls = "";
        } else if ("2".equals(hdtoolFalg) || item.getImmediatelyButton() == 0) {
            if (item.getSellerId() != null && item.getSellerId() != 0L) {
                StringBuffer sb = new StringBuffer();
                StringBuffer urlParam = new StringBuffer();
                Map mapRequest = null;
                if (!"".equals(returls)) {
                    mapRequest = UrlUtils.uRLRequest((String)returls);
                    for (String strRequestKey : mapRequest.keySet()) {
                        sb.append((String)mapRequest.get(strRequestKey));
                        if (urlParam.length() == 0) {
                            urlParam.append(String.valueOf(strRequestKey) + "=" + (String)mapRequest.get(strRequestKey));
                            continue;
                        }
                        urlParam.append("&" + strRequestKey + "=" + (String)mapRequest.get(strRequestKey));
                    }
                }
                if (orderId != null) {
                    String timestamp = DateUtils.getMillisecond();
                    sb.append(timestamp);
                    sb.append(orderId);
                    if (urlParam.length() == 0) {
                        urlParam.append("timestamp=" + timestamp);
                    } else {
                        urlParam.append("&timestamp=" + timestamp);
                    }
                    urlParam.append("&orderId=" + orderId);
                }
                SellerDto result = this.sellerSevice.findById(item.getSellerId());
                returls = String.valueOf(UrlUtils.urlPage((String)returls)) + "?" + urlParam + "&sign=" + SecurityUtils.encode2StringBySHA((String)(String.valueOf(sb.toString()) + result.getSafeSign()));
            }
            if (urlParameter != null && urlParameter.length() > 0 && embedClickurl != null && embedClickurl.length() > 0) {
                try {
                    returls = String.valueOf(embedClickurl) + URLEncoder.encode(returls, "utf-8") + urlParameter;
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        } else {
            returls = "/crecord/recordDetailNew/" + orderId + "?after=1";
        }
        return DubboResult.successResult((Object)returls);
    }

    @Override
    public DubboResult<String> selectImmediatelyButtonFromCoupon(Long couponId, Long itemId, Long orderId, String urlParameter, String embedClickurl, String hdtoolFalg) {
        if (itemId == null || orderId == null || couponId == null || hdtoolFalg == null) {
            return DubboResult.failResult((String)("\u8f93\u5165\u53c2\u6570 \u4e0d\u80fd\u4e3a\u7a7aitemId\uff1a" + itemId + " orderId:" + orderId + " couponId:" + couponId + " hdtoolFalg:" + hdtoolFalg));
        }
        String returls = "";
        ItemDO item = this.itemService.find(itemId);
        if (item == null) {
            return DubboResult.failResult((String)("\u60a8\u8f93\u5165\u7684 itemId" + itemId + " \u672a\u67e5\u627e\u5230\u5bf9\u5e94\u7684 \u4f18\u60e0\u5238\u4fe1\u606f"));
        }
        if (item.getImmediatelyButton() == 1 && "1".equals(hdtoolFalg)) {
            returls = "/crecord/recordDetailNew/" + orderId + "?after=1";
            return DubboResult.successResult((Object)returls);
        }
        CouponDO coupon = this.couponService.find(couponId);
        if (coupon == null) {
            return DubboResult.failResult((String)("\u60a8\u8f93\u5165\u7684 couponId" + itemId + " \u672a\u67e5\u627e\u5230\u5bf9\u5e94\u7684 \u4f18\u60e0\u5238\u4fe1\u606f"));
        }
        returls = coupon.getCode();
        if (item.getSellerId() != null && item.getSellerId() != 0L) {
            StringBuffer sb = new StringBuffer();
            StringBuffer urlParam = new StringBuffer();
            Map mapRequest = null;
            if (!"".equals(returls)) {
                mapRequest = UrlUtils.uRLRequest((String)returls);
                for (String strRequestKey : mapRequest.keySet()) {
                    sb.append((String)mapRequest.get(strRequestKey));
                    if (urlParam.length() == 0) {
                        urlParam.append(String.valueOf(strRequestKey) + "=" + (String)mapRequest.get(strRequestKey));
                        continue;
                    }
                    urlParam.append("&" + strRequestKey + "=" + (String)mapRequest.get(strRequestKey));
                }
            }
            if (orderId != null) {
                String timestamp = DateUtils.getMillisecond();
                sb.append(timestamp);
                sb.append(orderId);
                if (urlParam.length() == 0) {
                    urlParam.append("timestamp=" + timestamp);
                } else {
                    urlParam.append("&timestamp=" + timestamp);
                }
                urlParam.append("&orderId=" + orderId);
            }
            SellerDto result = this.sellerSevice.findById(item.getSellerId());
            returls = String.valueOf(UrlUtils.urlPage((String)returls)) + "?" + urlParam + "&sign=" + SecurityUtils.encode2StringBySHA((String)(String.valueOf(sb.toString()) + result.getSafeSign()));
        }
        if (urlParameter != null && urlParameter.length() > 0 && embedClickurl != null && embedClickurl.length() > 0) {
            try {
                returls = String.valueOf(embedClickurl) + URLEncoder.encode(returls, "utf-8") + urlParameter;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return DubboResult.successResult((Object)returls);
    }
}

