/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.item.service.impl;

import cn.com.duiba.service.domain.dataobject.AppItemDO;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.service.item.dao.ItemStockManualChangeDao;
import cn.com.duiba.service.item.domain.dataobject.ItemStockManualChangeDO;
import cn.com.duiba.service.item.service.AppItemService;
import cn.com.duiba.service.item.service.ItemStockManualChangeService;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItemStockManualChangeServiceImpl
implements ItemStockManualChangeService {
    @Resource
    private ItemStockManualChangeDao itemStockManualChangeDao;
    @Autowired
    private AppItemService appItemService;

    @Override
    @Transactional(value="credits")
    public boolean addStockQuantity(Long appItemId, Integer quantity) throws BusinessException {
        AppItemDO appItem = this.appItemService.find(appItemId);
        if (appItem == null) {
            throw new BusinessException("\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        if (!appItem.getType().equals("object") && !appItem.getType().equals("virtual")) {
            throw new BusinessException("\u4e0d\u652f\u6301" + appItem.getType() + "\u7c7b\u578b");
        }
        appItem = this.appItemService.findForUpdate(appItemId);
        int result = this.appItemService.addRemainingById(appItemId, quantity);
        if (result < 1) {
            throw new BusinessException("\u53d8\u66f4\u5546\u54c1\u5e93\u5b58\u5931\u8d25");
        }
        ItemStockManualChangeDO itemStockChange = new ItemStockManualChangeDO(true);
        itemStockChange.setRelationId(appItemId);
        itemStockChange.setRelationType("appItem");
        itemStockChange.setBeforeStock(Long.valueOf(appItem.getRemaining().intValue()));
        itemStockChange.setAfterStock(Long.valueOf(appItem.getRemaining() + quantity));
        itemStockChange.setChangeKind("add");
        itemStockChange.setChangeQuantity(Long.valueOf(quantity.intValue()));
        this.itemStockManualChangeDao.insert(itemStockChange);
        return true;
    }

    @Override
    @Transactional(value="credits")
    public boolean reduceStockQuantity(Long appItemId, Integer quantity) throws BusinessException {
        AppItemDO appItem = this.appItemService.find(appItemId);
        if (appItem == null) {
            throw new BusinessException("\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        if (!appItem.getType().equals("object") && !appItem.getType().equals("virtual")) {
            throw new BusinessException("\u4e0d\u652f\u6301" + appItem.getType() + "\u7c7b\u578b");
        }
        appItem = this.appItemService.findForUpdate(appItemId);
        int result = this.appItemService.subRemainingById(appItemId, quantity);
        if (result < 1) {
            throw new BusinessException("\u53d8\u66f4\u5546\u54c1\u5e93\u5b58\u5931\u8d25");
        }
        ItemStockManualChangeDO itemStockChange = new ItemStockManualChangeDO(true);
        itemStockChange.setRelationId(appItemId);
        itemStockChange.setRelationType("appItem");
        itemStockChange.setBeforeStock(Long.valueOf(appItem.getRemaining().intValue()));
        itemStockChange.setAfterStock(Long.valueOf(appItem.getRemaining() - quantity));
        itemStockChange.setChangeKind("sub");
        itemStockChange.setChangeQuantity(Long.valueOf(quantity.intValue()));
        this.itemStockManualChangeDao.insert(itemStockChange);
        return true;
    }
}

