package cn.com.duiba.duiba.stormrage.center.open.api.dto;

import cn.com.duiba.duiba.stormrage.center.open.api.enums.ActRiskSenceEnum;
import cn.com.duiba.duiba.stormrage.center.open.api.enums.ProjectXLabelEnum;
import cn.com.duiba.duiba.stormrage.center.open.api.enums.RiskRoutBizEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author chenyongkun
 * @date 2023/3/10
 */
@Data
public class DuibaStormEngineDto implements Serializable {
    private static final long serialVersionUID = 5700950316291800453L;

    /**
     * 活动来源 标明是 星速台活动还是非星速台活动
     */
    private RiskRoutBizEnum bizEnum;

    /**
     * 用户id
     */
    private Long consumerId;

    /**
     * 活动类型
     */
    private Integer activityType;

    /**
     * appId
     */
    private Long appId;

    /**
     * 活动id
     */
    private Long activityId;

    /**
     * 入库id
     */
    private Long operatingId;

    /**
     * 项目id
     */
    private String projectId;

    /**
     * 星速台项目 标签
     */
    private ProjectXLabelEnum label;


    /**
     * 风控主场景: 1 提现,2 参与,3 发奖,4 兑换 ，7 助力
     */
    private ActRiskSenceEnum scene;

    /**
     * 请求时间
     */
    private Date date;

    /**
     * ip
     */
    private String ip;

    /**
     * ua
     */
    private String ua;

    /**
     * 系统, 必须使用
     */
    private String os;

    /**
     * 支付宝账号
     */
    private String aliPayAccount;

    /**
     * 支付宝姓名
     */
    private String aliPayName;

    /**
     * 设备id
     */
    private String deviceId;

    /**
     * 商品id （用于兑换场景76）
     */
    private Long itemId;
    /**
     * 被助力用户id （用于助力场景77）
     */
    private Long assistedUserId;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 是否跳过ua校验
     */
    private Boolean needCheckUa = true;

    public Boolean getNeedCheckUa() {
        return needCheckUa;
    }

    public void setNeedCheckUa(Boolean needCheckUa) {
        this.needCheckUa = needCheckUa;
    }

    /**
     * 兑换商品为第三方平台的直充类商品时必填
     * 账号md5加密脱敏
     */
    private String account;
}
