package cn.com.duiba.duiba.stormrage.center.open.api.enums;

/**
 * projectX活动标签
 */
public enum ProjectXLabelEnum {

    CUSTOM(60000,"自定义"),
    ATTRACT_NEW_USER(60001,"拉新"),
    PROMOTE_ENERGY(60002,"促活"),
    REMAIN(60003,"留存"),
    CONSUME_CREDITS(60004,"积分消耗"),
    GEME(60005,"游戏"),
    SECKILL(60006,"秒杀"),
    ;


    private Integer code;

    private String desc;

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    ProjectXLabelEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }


    public static ProjectXLabelEnum getByType(Integer code){

        if(code == null){
            return null;
        }
        for(ProjectXLabelEnum item:ProjectXLabelEnum.values()){
            if(item.getCode().equals(code)){
                return item;
            }
        }
        return null;
    }

}
