package cn.com.duiba.duixintong.center.api.dto.activity;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
* 活动配置
 * @author meteor
 */
public class ActivityDto implements Serializable {

    private static final long serialVersionUID = 1543025418874882746L;
    /**
    * 主键
    */
    private Long id;

    /**
    * 活动类型：1-进件, 2-首刷
    */
    private Integer activityType;

    /**
    * 活动名称
    */
    private String activityName;

    /**
    * 开始时间
    */
    private Date startTime;

    /**
    * 结束时间
    */
    private Date endTime;

    /**
    * 银行ID
    */
    private Long bankId;

    /**
     * 银行名称
     */
    private String bankName;

    /**
    * 银行scc码
    */
    private String bankScc;

    /**
    * 银行mt码
    */
    private String bankMt;

    /**
     * ccp配置
     */
    private String bankCcp;

    /**
    *  banner图片
    */
    private String bannerImg;

    /**
    * 活动介绍
    */
    private String activityDesc;

    /**
    * 是否启用, 0-停用, 1-启用
    */
    private Integer activityStatus;

    /**
    * 是否逻辑删除, 0-未删除, 1-已删除
    */
    private Integer logicDelete;

    /**
     * 关联权益
     */
    private List<ActivityEquityDto> equityList;

    /**
     * 是否关联商户
     */
    private boolean hasBusiness;

    /**
     * 关联商户id
     */
    private List<ActivityBusinessDto> businessList;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;


    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    public Integer getActivityType() {
        return activityType;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public String getActivityName() {
        return activityName;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setBankId(Long bankId) {
        this.bankId = bankId;
    }

    public Long getBankId() {
        return bankId;
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public void setBankScc(String bankScc) {
        this.bankScc = bankScc;
    }

    public String getBankScc() {
        return bankScc;
    }

    public void setBankMt(String bankMt) {
        this.bankMt = bankMt;
    }

    public String getBankMt() {
        return bankMt;
    }

    public String getBankCcp() {
        return bankCcp;
    }

    public void setBankCcp(String bankCcp) {
        this.bankCcp = bankCcp;
    }

    public void setBannerImg(String bannerImg) {
        this.bannerImg = bannerImg;
    }

    public String getBannerImg() {
        return bannerImg;
    }

    public void setActivityDesc(String activityDesc) {
        this.activityDesc = activityDesc;
    }

    public String getActivityDesc() {
        return activityDesc;
    }

    public void setActivityStatus(Integer activityStatus) {
        this.activityStatus = activityStatus;
    }

    public Integer getActivityStatus() {
        return activityStatus;
    }

    public void setLogicDelete(Integer logicDelete) {
        this.logicDelete = logicDelete;
    }

    public Integer getLogicDelete() {
        return logicDelete;
    }

    public List<ActivityEquityDto> getEquityList() {
        return equityList;
    }

    public boolean isHasBusiness() {
        return hasBusiness;
    }

    public void setHasBusiness(boolean hasBusiness) {
        this.hasBusiness = hasBusiness;
    }

    public List<ActivityBusinessDto> getBusinessList() {
        return businessList;
    }

    public void setBusinessList(List<ActivityBusinessDto> businessList) {
        this.businessList = businessList;
    }

    public void setEquityList(List<ActivityEquityDto> equityList) {
        this.equityList = equityList;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

}

