package cn.com.duiba.duixintong.center.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duixintong.center.api.dto.activity.ActivityDto;
import cn.com.duiba.duixintong.center.api.dto.activity.BusinessActivityDto;
import cn.com.duiba.duixintong.center.api.param.activity.ActivityQueryParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * @author: pengyi
 * @description:
 * @date: 2023/5/17 15:04
 */
@AdvancedFeignClient
public interface RemoteActivityService {

    /**
     * 活动分页查询
     * @param queryParam
     * @return
     */
    PageResponse<ActivityDto> pageByParam(ActivityQueryParam queryParam);

    /**
     * 新建/编辑 活动
     * @param activityDto
     * @return
     */
    int edit(ActivityDto activityDto);

    /**
     * 活动详情
     * @param id
     * @return
     */
    ActivityDto detailById(Long id);

    /**
     * 启用/禁用活动
     * @param activityId
     * @param enable
     * @return
     */
    boolean operateActivityStatus(Long activityId, boolean enable);

    /**
     * 活动关联商家
     * @param activityId
     * @param businessId
     * @return
     */
    boolean bindBusiness(Long activityId, List<Long> businessId);

    /**
     * C端活动分页查询
     * @param queryParam
     * @return
     */
    PageResponse<ActivityDto> pageByBusinessParam(ActivityQueryParam queryParam);

    /**
     * 商家端活动详情
     * @param businessId
     * @param activityId
     * @return
     */
    BusinessActivityDto businessActivityDetail(Long businessId, Long activityId);
}
