package cn.com.duiba.duixintong.center.api.remoteservice.reference;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duixintong.center.api.dto.reference.ReferenceRelatedDto;

/**
 * 推荐人商家关联
 * @author lizhi
 * @date 2023/5/21 4:25 PM
 */
@AdvancedFeignClient
public interface RemoteReferenceRelatedService {

    /**
     * 根据唯一键查询
     * @param userId 用户ID
     * @param businessId 商家ID
     * @return 推荐人商家关联
     */
    ReferenceRelatedDto selectByUk(Long userId, Long businessId);

    /**
     * 新增或更新
     * @param dto 推荐人商家关联
     * @return 执行结果
     */
    int saveOrUpdate(ReferenceRelatedDto dto);
}
