package cn.com.duiba.duixintong.center.api.utils;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

/**
 * @author lizhi
 * @date 2023/5/16 4:41 PM
 */
@Slf4j
public class UrlUtils {
    
    private UrlUtils() {}

    public static String encoder(String url) {
        try {
            return URLEncoder.encode(url, StandardCharsets.UTF_8.name());
        } catch (Exception e) {
            log.warn("url encoder error url={}", url, e);
        }
        return url;
    }

    public static String decoder(String url) {
        try {
            return URLDecoder.decode(url, StandardCharsets.UTF_8.name());
        } catch (Exception e) {
            log.warn("url decoder error url={}", url, e);
        }
        return url;
    }


    /**
     * 在url上拼接query param
     * 可以过滤空字符串
     */
    public static String appendQueryParam(String url, String... infos) {
        if (StringUtils.isEmpty(url) || ArrayUtils.isEmpty(infos)) {
            return url;
        }
        String params = buildParams(infos);
        if (StringUtils.isBlank(params)) {
            return url;
        }
        if (url.contains("?")) {
            return url + params;
        }
        return url + "?" + params;
    }
    
    public static String buildParams(String... infos) {
        if (infos == null || infos.length < 1) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String info : infos) {
            String trimInfo = StringUtils.trim(info);
            if (StringUtils.isEmpty(trimInfo)) {
                continue;
            }
            sb.append('&');
            sb.append(trimInfo);
        }
        if (sb.length() < 1) {
            return "";
        }
        return sb.substring(1);
    }
}
