/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.duixintong.center.api.enums.statistics;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Triple;

public enum DimensionStatisticsEnum {
    BUSINESS(1, "\u5546\u5bb6\u7ef4\u5ea6"),
    BUSINESS_REFERENCE(2, "\u5546\u5bb6+\u63a8\u8350\u4eba\u7ef4\u5ea6"),
    BUSINESS_ACTIVITY(3, "\u5546\u5bb6+\u6d3b\u52a8\u7ef4\u5ea6"),
    REFERENCE_BUSINESS_ACTIVITY(4, "\u5546\u5bb6+\u63a8\u8350\u4eba+\u6d3b\u52a8\u7ef4\u5ea6");

    private final Integer dimension;
    private final String desc;
    public static final Set<DimensionStatisticsEnum> ORDER_STAT_DIMENSION_SET;
    public static final Set<DimensionStatisticsEnum> CUSTOMER_STAT_DIMENSION_SET;
    public static final Set<DimensionStatisticsEnum> EQUITY_STAT_DIMENSION_SET;
    public static final Set<DimensionStatisticsEnum> REFERENCE_STAT_DIMENSION_SET;
    private static final Map<Integer, DimensionStatisticsEnum> ENUM_MAP;

    public String buildCombinationId(Long businessId, Long activityId, Long referenceUserId) {
        switch (this) {
            case BUSINESS: {
                return this.doBuildCombinationId(businessId);
            }
            case BUSINESS_REFERENCE: {
                return this.doBuildCombinationId(businessId, referenceUserId);
            }
            case BUSINESS_ACTIVITY: {
                return this.doBuildCombinationId(businessId, activityId);
            }
            case REFERENCE_BUSINESS_ACTIVITY: {
                return this.doBuildCombinationId(businessId, referenceUserId, activityId);
            }
        }
        return null;
    }

    public Triple<Long, Long, Long> parseCombinationId(String combinationId) {
        if (StringUtils.isBlank((CharSequence)combinationId)) {
            return Triple.of(null, null, null);
        }
        String[] split = combinationId.split(",");
        switch (this) {
            case BUSINESS: {
                return Triple.of((Object)NumberUtils.toLong((String)split[0]), null, null);
            }
            case BUSINESS_REFERENCE: {
                return Triple.of((Object)NumberUtils.toLong((String)split[0]), null, (Object)NumberUtils.toLong((String)split[1]));
            }
            case BUSINESS_ACTIVITY: {
                return Triple.of((Object)NumberUtils.toLong((String)split[0]), (Object)NumberUtils.toLong((String)split[1]), null);
            }
            case REFERENCE_BUSINESS_ACTIVITY: {
                return Triple.of((Object)NumberUtils.toLong((String)split[0]), (Object)NumberUtils.toLong((String)split[2]), (Object)NumberUtils.toLong((String)split[1]));
            }
        }
        return Triple.of(null, null, null);
    }

    private String doBuildCombinationId(Long ... ids) {
        StringBuilder sb = new StringBuilder();
        for (Long id : ids) {
            sb.append(",");
            sb.append(id);
        }
        return sb.substring(1);
    }

    public static DimensionStatisticsEnum getByDimension(Integer dimension) {
        if (dimension == null) {
            return null;
        }
        return ENUM_MAP.get(dimension);
    }

    public Integer getDimension() {
        return this.dimension;
    }

    public String getDesc() {
        return this.desc;
    }

    private DimensionStatisticsEnum(Integer dimension, String desc) {
        this.dimension = dimension;
        this.desc = desc;
    }

    static {
        ORDER_STAT_DIMENSION_SET = Collections.unmodifiableSet(Arrays.stream(DimensionStatisticsEnum.values()).collect(Collectors.toSet()));
        CUSTOMER_STAT_DIMENSION_SET = Collections.unmodifiableSet(Stream.of(BUSINESS, BUSINESS_REFERENCE).collect(Collectors.toSet()));
        EQUITY_STAT_DIMENSION_SET = Collections.unmodifiableSet(Stream.of(BUSINESS, BUSINESS_REFERENCE).collect(Collectors.toSet()));
        REFERENCE_STAT_DIMENSION_SET = Collections.unmodifiableSet(Stream.of(BUSINESS).collect(Collectors.toSet()));
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(DimensionStatisticsEnum.values()).collect(Collectors.toMap(DimensionStatisticsEnum::getDimension, Function.identity(), (v1, v2) -> v2)));
    }
}

