package cn.com.duiba.duixintong.center.api.remoteservice.channel;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duixintong.center.api.dto.channel.auth.OaUserInfoResultDto;
import cn.com.duiba.duixintong.center.api.dto.channel.auth.OaUserTokenResultDto;

/**
 * 公众号授权相关
 * @author lizhi
 * @date 2023/5/16 5:10 PM
 */
@AdvancedFeignClient
public interface RemoteOaAuthService {
    
    /**
     * 根据用户静默授权的code，获取userToken,和openId
     * @param oaId 公众号ID
     * @param code 静默授权code
     * @return 微信返回的授权信息
     */
    OaUserTokenResultDto getUserTokenByCode(Long oaId , String code);

    /**
     * 公众号 手动授权后，根据token获取userInfo
     * @param userToken 用户静默授权code换取的access_token
     * @param openId 用户静默授权后可获得
     * @return 微信返回的手动授权信息
     */
    OaUserInfoResultDto getUserInfoByToken(String userToken, String openId);

    /**
     * 获取微信分享使用的jsapi_ticket
     * @param oaId 授权公众号ID
     * @return ticket
     */
    String getJsApiTicket(Long oaId);
}
