package cn.com.duiba.duixintong.center.api.dto.fund;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 资金账户流水表
 * @author kjj mybatis generator 
 * @date 2023-06-06
 */
@Data
public class FundAccountChangeRecordDto implements Serializable {
     
    private static final long serialVersionUID = 16860428097216622L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 流水号
     */
    private String detailNo;

    /**
     * 商家ID，用于商家维度分页查询
     */
    private Long businessId;

    /**
     * 账户ID，推荐人ID(账户类型-1)，商家ID(账户类型-2)，重客ID(账户类型-3)
     */
    private Long accountId;

    /**
     * 账户类型，1-推荐人，2-商家，3-重客
     * {@link cn.com.duiba.duixintong.center.api.enums.fund.FundAccountTypeEnum}
     */
    private Integer accountType;

    /**
     * 变更类型，1-支出, 2-收入
     * {@link cn.com.duiba.duixintong.center.api.enums.fund.FundAccountChangeTypeEnum}
     */
    private Integer changeType;

    /**
     * 业务类型，1-提现，2-提现失败回退，3-重客分佣，4-商家分佣，5-推荐人分佣
     * {@link cn.com.duiba.duixintong.center.api.enums.fund.FundAccountBizTypeEnum}
     */
    private Integer bizType;

    /**
     * 关联业务唯一标识
     */
    private String bizNo;

    /**
     * 变更金额(分)
     */
    private Long changeMoney;

    /**
     * 变更后累计收益(分)
     */
    private Long afterIncome;

    /**
     * 变更后余额(分)
     */
    private Long afterBalance;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}