package cn.com.duiba.duixintong.center.api.enums.fund;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 账户业务类型
 * @author lizhi
 * @date 2023/6/6 5:18 PM
 */
@Getter
@AllArgsConstructor
public enum FundAccountBizTypeEnum {
    // 1-提现，2-提现失败回退，3-重客分佣，4-商家分佣，5-推荐人分佣
    WITHDRAW(1, FundAccountChangeTypeEnum.EXPEND, "提现"),
    WITHDRAW_BACK(2, FundAccountChangeTypeEnum.INCOME, "提现失败回退"),
    MAJOR_CUSTOMER(3, FundAccountChangeTypeEnum.INCOME, "重客分佣"),
    BUSINESS(4, FundAccountChangeTypeEnum.INCOME, "商家分佣"),
    REFERENCE(5, FundAccountChangeTypeEnum.INCOME, "推荐人分佣"),
    ;
    
    private final Integer type;
    
    private final FundAccountChangeTypeEnum changeTypeEnum;
    
    private final String desc;
    
    private static final Map<Integer, FundAccountBizTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(FundAccountBizTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));
    
    /**
     * 根据枚举值获取枚举
     * @param type 枚举值
     * @return 枚举
     */
    public static FundAccountBizTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
