package cn.com.duiba.duixintong.center.api.enums.order;

import java.util.Objects;

public enum BankCardOrderEnum {

    CREATE(1, "访问"),
    INCMING_PARTS_FAIL(2, "进件失败"),
    INCMING_PARTS_SUCCESS(3, "进件成功"),
    APPRAVAL(4,"核批"),
    REJECT(5,"拒批"),
    ACTIVATED(6,"激活"),
    FIRSTUSED(7,"首刷"),
    ;

    private Integer code;

    private String desc;

    public static BankCardOrderEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        BankCardOrderEnum[] values = BankCardOrderEnum.values();
        for (BankCardOrderEnum value : values) {
            if (Objects.equals(value.getCode(), code)) {
                return value;
            }
        }
        return null;
    }

    BankCardOrderEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
