package cn.com.duiba.duixintong.center.api.remoteservice.equity;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duixintong.center.api.dto.equity.EquityDto;
import cn.com.duiba.duixintong.center.api.param.equity.EquityQueryParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * @author: pengyi
 * @description:
 * @date: 2023/5/17 10:38
 */
@AdvancedFeignClient
public interface RemoteEquityService {

    /**
     * 权益分页查询
     * @param queryParam
     * @return
     */
    PageResponse<EquityDto> pageByParam(EquityQueryParam queryParam);

    /**
     * 新建/编辑 权益
     * @param equityDto
     * @return
     * @throws BizException
     */
    int edit(EquityDto equityDto) throws BizException;

    /**
     * 权益详情
     * @param id
     * @return
     */
    EquityDto detailById(Long id);

    /**
     * 批量查询权益
     * @param ids 主键集合
     * @return 权益详情
     */
    List<EquityDto> getByIds(List<Long> ids);
}
