package cn.com.duiba.duixintong.center.api.remoteservice.padAbutment;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duixintong.center.api.dto.pabAbutment.PabOrderStatusResponse;

/**
 * 平安银行对接接口的服务
 * @author yangyukang
 */
@AdvancedFeignClient
public interface RemotePadAbutmentService {
    /**
     * 获取平安银行申卡页面url
     * @param orderId 流水号
     * @return url
     */
    String applyForCardUrl(String orderId, String scc, String ccp, String mt) throws BizException;

    /**
     * 查询卡结果
     * @param bizNo 办卡流水号
     * @return PadOrderStatusResponse
     */
    PabOrderStatusResponse queryOrderStauts(String bizNo) throws BizException;

    /**
     * 银行回调发放权益
     * @param bizNo
     */
    void notifySendEquity(String bizNo);
}
