/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.duixintong.center.api.enums.msg;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum MessageTypeEnum {
    CUSTOMER_TEXT(1, "text", "\u5ba2\u670d\u6587\u5b57\u6d88\u606f(\u516c\u4f17\u53f7\u548c\u5c0f\u7a0b\u5e8f\u90fd\u652f\u6301)"),
    CUSTOMER_PIC(2, "image", "\u5ba2\u670d\u56fe\u7247\u6d88\u606f(\u516c\u4f17\u53f7\u548c\u5c0f\u7a0b\u5e8f\u90fd\u652f\u6301)"),
    CUSTOMER_VOICE(3, "voice", "\u5ba2\u670d\u97f3\u9891\u6d88\u606f(\u4ec5\u516c\u4f17\u53f7\u652f\u6301)"),
    CUSTOMER_MUSIC(4, "music", "\u5ba2\u670d\u97f3\u4e50\u6d88\u606f(\u4ec5\u516c\u4f17\u53f7\u652f\u6301)"),
    CUSTOMER_VIDEO(5, "video", "\u5ba2\u670d\u89c6\u9891\u6d88\u606f(\u4ec5\u516c\u4f17\u53f7\u652f\u6301)"),
    CUSTOMER_CARD(6, "news", "\u5ba2\u670d\u5361\u7247\u6d88\u606f(\u4ec5\u516c\u4f17\u53f7\u652f\u6301)"),
    CUSTOMER_MENU(7, "msgmenu", "\u5ba2\u670d\u83dc\u5355\u6d88\u606f(\u4ec5\u516c\u4f17\u53f7\u652f\u6301)"),
    CUSTOMER_MP_CARD(8, "miniprogrampage", "\u5ba2\u670d\u5c0f\u7a0b\u5e8f\u6d88\u606f(\u4ec5\u516c\u4f17\u53f7\u652f\u6301)"),
    CUSTOMER_COUPON(9, "wxcard", "\u5ba2\u670d\u5361\u5238\u6d88\u606f(\u4ec5\u516c\u4f17\u53f7\u652f\u6301)"),
    TEMPLATE(10, "template", "\u6a21\u7248\u6d88\u606f(\u516c\u4f17\u53f7\u548c\u5c0f\u7a0b\u5e8f\u90fd\u652f\u6301)"),
    SUBSCRIBE(11, "subscribe", "\u5c0f\u7a0b\u5e8f\u8ba2\u9605\u6d88\u606f(\u4ec5\u5c0f\u7a0b\u5e8f\u652f\u6301)"),
    MP_CUSTOMER_LINK(12, "link", "\u5c0f\u7a0b\u5e8f\u5ba2\u670d\u56fe\u6587\u6d88\u606f(\u4ec5\u5c0f\u7a0b\u5e8f\u652f\u6301)");

    private final Integer code;
    private final String wxType;
    private final String desc;
    private static final Map<Integer, MessageTypeEnum> ENUM_MAP;

    public boolean isCustomerMessage() {
        return this.code < TEMPLATE.getCode();
    }

    public boolean isTemplateMessage() {
        return this.code.equals(TEMPLATE.getCode());
    }

    public boolean isSubscribeMessage() {
        return this.code.equals(SUBSCRIBE.getCode());
    }

    public static MessageTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public Integer getCode() {
        return this.code;
    }

    public String getWxType() {
        return this.wxType;
    }

    public String getDesc() {
        return this.desc;
    }

    private MessageTypeEnum(Integer code, String wxType, String desc) {
        this.code = code;
        this.wxType = wxType;
        this.desc = desc;
    }

    static {
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(MessageTypeEnum.values()).collect(Collectors.toMap(MessageTypeEnum::getCode, Function.identity(), (v1, v2) -> v2)));
    }
}

