package cn.com.duiba.duixintong.center.api.enums.msg;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 推送消息类型
 * @author lizhi
 * @date 2021/12/27 1:58 下午
 */
@Slf4j
@Getter
@AllArgsConstructor
public enum PushMsgTypeEnum {

    WX_OA_TEXT(1, "客服文本消息"),
    WX_OA_PIC_TEXT(2, "客服图文消息"),
    WX_OA_TEMPLATE(3, "模板消息"),
    WX_OA_MINI(4, "公众号客服小程序卡片"),
    WX_OA_PIC(5, "公众号图片消息"),
    WX_MP_SUBSCRIBE(11, "小程序订阅消息"),
    WX_MP_PIC(12, "小程序客服图片消息"),
    WX_MP_PIC_TEXT(13, "小程序客服图文消息"),
    // 企微
    WX_WORK_TEXT(14, "企微客服文本消息"),
    WX_WORK_TEMPLATE(15, "企微模板消息"),
    ;

    /**
     * 类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;



    private static final Map<Integer, PushMsgTypeEnum> ENUM_MAP = Collections.unmodifiableMap(
            Arrays.stream(values()).collect(Collectors.toMap(PushMsgTypeEnum::getType, Function.identity(), (v1, v2) -> {
                log.error("PushMsgTypeEnum, type distinct, type={}", v2.getType());
                return v2;
            }))
    );

    /**
     * 根据类型获取枚举
     * @param type 类型
     * @return 枚举
     */
    public static PushMsgTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
