package cn.com.duiba.duixintong.center.api.param.card;

import cn.com.duiba.duixintong.center.api.enums.statistics.DateTypeEnum;
import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.Date;

/**
 * @author: pengyi
 * @description:
 * @date: 2023/5/19 17:07
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class CardPageQueryParam extends PageRequest {

    private static final long serialVersionUID = 7384292251717466343L;

    /**
     * 推荐人id
     */
    private Long referenceUserId;

    /**
     * 商家id
     */
    private Long businessId;

    /**
     * 活动id
     */
    private Long activityId;

    /**
     * 卡状态
     */
    private Integer cardStatus;

    /**
     * 时间维度
     * @see DateTypeEnum
     */
    private String dateType;

    /**
     * 查询开始时间
     */
    private Date startTime;

    /**
     * 查询截止时间
     */
    private Date endTime;
}
