package cn.com.duiba.duixintong.center.api.param.customer;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 客户查询参数
 * @author lizhi
 * @date 2023/5/30 6:19 PM
 */
@ToString
@EqualsAndHashCode(callSuper = true)
@Data
public class CustomerQueryParam extends PageRequest {
    
    private static final long serialVersionUID = 856749952771503236L;

    /**
     * 统计维度
     * {@link cn.com.duiba.duixintong.center.api.enums.statistics.DimensionStatisticsEnum}
     */
    private Integer statDimension;

    /**
     * 商家ID
     */
    private Long businessId;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 推荐人ID
     */
    private Long referenceUserId;

    /**
     * 关联的专员ID，对应tb_commissioner.id
     */
    private Long commissionerId;

    /**
     * 关联的重客ID，对应tb_important_customer.id
     */
    private Long importantCustomerId;
}
