package cn.com.duiba.duixintong.center.api.param.fund;

import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2023/6/6 5:39 PM
 */
@Data
public class FundAccountChangeParam implements Serializable {

    private static final long serialVersionUID = 4765536960444247253L;
    
    /**
     * 商家ID，用于商家维度分页查询，若无则不传(accountType为商家时也不传)
     */
    private Long businessId;

    /**
     * 账户ID，推荐人ID(账户类型-1)，商家ID(账户类型-2)，重客ID(账户类型-3)
     */
    private Long accountId;

    /**
     * 账户类型，1-推荐人，2-商家，3-重客
     * {@link cn.com.duiba.duixintong.center.api.enums.fund.FundAccountTypeEnum}
     */
    private Integer accountType;

    /**
     * 业务类型，1-提现，2-提现失败回退，3-重客分佣，4-商家分佣，5-推荐人分佣
     * {@link cn.com.duiba.duixintong.center.api.enums.fund.FundAccountBizTypeEnum}
     */
    private Integer bizType;

    /**
     * 关联业务唯一标识
     */
    private String bizNo;

    /**
     * 变更金额(分)
     */
    private Long changeMoney;

    /**
     * 备注，若无则不传
     */
    private String remark;
}
