package cn.com.duiba.duixintong.center.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duixintong.center.api.dto.activity.ActivityCertificateRecordDto;
import cn.com.duiba.duixintong.center.api.dto.activity.ActivityDetailDto;
import cn.com.duiba.duixintong.center.api.dto.activity.ActivityDto;
import cn.com.duiba.duixintong.center.api.dto.activity.BusinessActivityDto;
import cn.com.duiba.duixintong.center.api.param.activity.ActivityQueryParam;
import cn.com.duiba.wolf.entity.PageResponse;
import org.apache.commons.lang3.tuple.Pair;

import java.util.List;

/**
 * @author: pengyi
 * @description:
 * @date: 2023/5/17 15:04
 */
@AdvancedFeignClient
public interface RemoteActivityService {

    /**
     * 活动分页查询
     * @param queryParam
     * @return
     */
    PageResponse<ActivityDetailDto> pageByParam(ActivityQueryParam queryParam);

    /**
     * 根据id批量查询
     * @param ids 主键集合
     * @return 活动列表
     */
    List<ActivityDto> getByIds(List<Long> ids);

    /**
     * 新建/编辑 活动
     * @param activityDto
     * @return
     */
    int edit(ActivityDetailDto activityDto);

    /**
     * 活动详情
     * @param id
     * @return
     */
    ActivityDto getById(Long id);

    /**
     * 活动详情
     * @param id
     * @return
     */
    ActivityDetailDto detailById(Long id);

    /**
     * 启用/禁用活动
     * @param activityId
     * @param enable
     * @return
     */
    boolean operateActivityStatus(Long activityId, boolean enable);

    /**
     * 活动关联商家
     * @param activityId
     * @param businessId
     * @return
     */
    boolean bindBusiness(Long activityId, List<Long> businessId);

    /**
     * C端活动分页查询
     * @param queryParam 查询参数
     * @return 活动详情
     */
    List<ActivityDto> listByBusinessParam(ActivityQueryParam queryParam);

    /**
     * 商家端活动详情
     * @param businessId
     * @param activityId
     * @return
     */
    BusinessActivityDto businessActivityDetail(Long businessId, Long activityId);

    /**
     * 活动数量统计
     * @param businessId 商家ID
     * @return left：使用中数量，right：已停用数量
     */
    Pair<Long, Long> stat(Long businessId);

    /**
     * 根据活动ID统计
     * @param activityIds 活动ID集合
     * @return left：使用中数量，right：已停用数量
     */
    Pair<Long, Long> statByActivityIds(List<Long> activityIds);

    /**
     * 分页从es查询
     * @param param 分页参数
     * @return left：总条数，right：活动
     */
    Pair<Long, List<ActivityDto>> selectPageByEs(ActivityQueryParam param);

}
