package cn.com.duiba.duixintong.center.api.dto.es;

import cn.com.duiba.duixintong.center.api.enums.order.BankOrderGrantStautsEnum;
import io.searchbox.annotations.JestId;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @author lizhi
 * @date 2023/6/6 11:33 AM
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class BankCardOrderEsDto extends BaseEsDto {
    
    private static final long serialVersionUID = 6660596518776529150L;

    /**
     * 主键
     */
    @JestId
    private Long id;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 用户的昵称
     */
    private String nickname;

    /**
     * 用户的头像
     */
    private String avatar;

    /**
     * 推荐人用户id
     */
    private Long referenceUserId;

    /**
     * 推荐人昵称
     */
    private String referenceNickname;

    /**
     * 推荐人头像
     */
    private String referenceAvatar;

    /**
     * 商家ID
     */
    private Long businessId;

    /**
     * 商家logo
     */
    private String businessLogo;

    /**
     * 商家名称
     */
    private String businessName;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 银行ID
     */
    private Long bankId;

    /**
     * 银行名称
     */
    private String bankName;

    /**
     * 渠道：
     */
    private Integer bankChannel;

    /**
     * 关联的专员ID，对应tb_commissioner.id
     */
    private Long commissionerId;

    /**
     * 关联的重客ID，对应tb_important_customer.id
     */
    private Long importantCustomerId;

    /**
     * 订单编号,唯一
     */
    private String orderNum;

    /**
     * 订单最新状态 1-创建，2-进件失败，3-进件成功，4-核批，5-拒批
     * @see cn.com.duiba.duixintong.center.api.enums.order.BankCardOrderEnum
     */
    private Integer cardStatus;

    /**
     * 发放状态  1，拒绝发放  2-发放
     * @see BankOrderGrantStautsEnum
     */
    private Integer grantStatus;

    /**
     * 发放账号
     */
    private String grantAccount;

    /**
     * 原因及明细
     */
    private String grantReason;

    /**
     * 最新银行回调信息字段
     */
    private String bankCallbackInfo;

    /**
     * 创建时间
     */
    private Long gmtCreate;

    /**
     * 修改时间
     */
    private Long gmtModified;

    /**
     * 是否新用户
     */
    private Integer isNewUser;

    /**
     * 已分佣类型（二进制表示）
     * @see cn.com.duiba.duixintong.center.api.enums.order.OrderCommissionTypeEnum
     */
    private Long commissionType;
}
