package cn.com.duiba.duixintong.center.api.remoteservice.common;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duixintong.center.api.dto.common.RegisterDto;
import cn.com.duiba.duixintong.center.api.param.register.RegisterCommissionerParam;
import cn.com.duiba.duixintong.center.api.param.register.RegisterImportantParam;

/**
 * 账号注册表
 * @author lizhi
 * @date 2023/6/28 4:43 PM
 */
@AdvancedFeignClient
public interface RemoteRegisterService {

    /**
     * 根据用户查询
     * @param userId 用户ID
     * @return 账号注册
     */
    RegisterDto selectByUserId(Long userId);

    /**
     * 注册专员
     * @param param 注册信息
     * @throws BizException 失败时抛出异常
     */
    void registerCommissioner(RegisterCommissionerParam param) throws BizException;

    /**
     * 注册重客
     * @param param 注册信息
     * @throws BizException 失败时抛出异常
     */
    void registerImportantCustomer(RegisterImportantParam param) throws BizException;
}
