package cn.com.duiba.duixintong.center.api.remoteservice.withdraw;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duixintong.center.api.dto.withdraw.WithdrawUserDto;

/**
 * 提现用户表 服务
 * @author lizhi
 * @date 2023/6/19 5:28 PM
 */
@AdvancedFeignClient
public interface RemoteWithdrawUserService {

    /**
     * 查询提现用户信息
     * @param accountId 账户ID，推荐人ID(账户类型-1)，商家ID(账户类型-2)，重客ID(账户类型-3)
     * @param accountType 账户类型，1-推荐人，2-商家，3-重客
     * @see cn.com.duiba.duixintong.center.api.enums.fund.FundAccountTypeEnum
     * @return 提现用户
     */
    WithdrawUserDto selectByAccount(Long accountId, Integer accountType);

    /**
     * 新增
     * @param dto 提现用户
     * @return 执行结果
     */
    int insert(WithdrawUserDto dto);

    /**
     * 修改姓名
     * @param id 主键
     * @param userName 姓名
     * @return 执行结果
     */
    int updateUserName(Long id, String userName);
}
