package cn.com.duiba.duixintong.center.api.dto.card;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * 分佣结果
 * @author lizhi
 * @date 2023/7/12 10:53 AM
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
public class OrderCommissionSharingResult implements Serializable {
    
    private static final long serialVersionUID = 8596792190104161467L;

    /**
     * 分佣类型
     * @see cn.com.duiba.duixintong.center.api.enums.order.OrderCommissionTypeEnum
     */
    private Integer type;

    /**
     * 状态码
     */
    private String code;

    /**
     * 描述信息
     */
    private String msg;

    /**
     * 分佣时的推荐人手机号
     */
    private String phone;

    /**
     * 奖励
     */
    private Long reward;

    /**
     * 奖励的权益idList（V2版分佣有值）
     */
    private List<Long> rewardEquityIdList;

    /**
     * 分佣时间
     */
    private Long time;

}
