package cn.com.duiba.duixintong.center.api.enums.withdraw;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Getter
@AllArgsConstructor
public enum WithdrawOrderStatusEnum {

//    DEFAULT(0, "默认"),

    /**
     * 处理中
     */
    PROCESSING(1, "处理中"),
    /**
     * 成功
     */
    SUCCESS(2, "成功"),
    /**
     * 失败
     */
    FAIL(3, "失败"),
    /**
     * 已返还
     */
    RETURN(4, "已返还"),
    /**
     * 已核销
     */
    VERIFICATION(5, "已核销"),
    /**
     * 已过期
     */
    EXPIRE(6, "已过期"),
    /**
     * 待兑换
     */
    WAIT_EXCHANGE(7, "待兑换"),
    ;


    private Integer status;

    private String statusText;

    /**
     * 待兑换查询状态集合
     */
    public static final Set<Integer> WAIT_EXCHANGE_SEARCH_SET = Collections.unmodifiableSet(Stream.of(WAIT_EXCHANGE.getStatus(), PROCESSING.getStatus(), FAIL.getStatus()).collect(Collectors.toSet()));

    /**
     * 已兑换查询状态集合
     */
    public static final Set<Integer> HAS_EXCHANGE_SEARCH_SET = Collections.unmodifiableSet(Stream.of(SUCCESS.getStatus(), VERIFICATION.getStatus()).collect(Collectors.toSet()));

    public static WithdrawOrderStatusEnum getByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        WithdrawOrderStatusEnum[] values = WithdrawOrderStatusEnum.values();
        for (WithdrawOrderStatusEnum value : values) {
            if (Objects.equals(value.getStatus(), status)) {
                return value;
            }
        }
        return null;
    }

}
