package cn.com.duiba.duixintong.center.api.param.business;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 商家分页查询参数
 * @author lizhi
 * @date 2023/6/13 2:53 PM
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class BusinessSearchParam extends PageRequest {
    
    private static final long serialVersionUID = -1470855195451281063L;
    
    /**
     * 主键
     */
    private Long id;

    /**
     * 商家名称
     */
    private String businessName;

    /**
     * 银行ID
     */
    private Long bankId;

    /**
     * 渠道：1-产险，2-车险，3-寿险，4-直销
     * @see cn.com.duiba.duixintong.center.api.enums.business.BankChannelEnum
     */
    private Integer bankChannel;

    /**
     * 商家状态:0-停用，1-启用
     * {@link cn.com.duiba.duixintong.center.api.enums.BooleanEnum}
     */
    private Integer businessStatus;

    /**
     * 关联的专员ID，对应tb_commissioner.id
     */
    private Long commissionerId;

    /**
     * 关联的重客ID，对应tb_important_customer.id
     */
    private Long importantCustomerId;
}
