package cn.com.duiba.duixintong.center.api.param.equity;

import cn.com.duiba.duixintong.center.api.enums.business.BankChannelEnum;
import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * @author: pengyi
 * @description:
 * @date: 2023/5/17 10:42
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class EquityQueryParam extends PageRequest {

    private static final long serialVersionUID = 2911660717182207478L;
    /**
     * 权益id
     */
    private Long id;

    /**
     * 权益名称
     */
    private String equityName;

    /**
     * 银行id
     */
    private Long bankId;

    /**
     * 渠道
     * @see cn.com.duiba.duixintong.center.api.enums.business.BankChannelEnum
     */
    private Integer channelType;

    /**
     * 批次号
     */
    private String batchNo;

    /**
     * 有效期开始时间
     */
    private Date startTime;

    /**
     * 有效期结束时间
     */
    private Date endTime;

}
