package cn.com.duiba.duixintong.center.api.remoteservice.exchange;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duixintong.center.api.dto.exchange.ExchangeEquityDto;
import cn.com.duiba.duixintong.center.api.param.exchange.ExchangeEquitySearchParam;

import java.util.List;

/**
 * 兑换权益
 * @author yangyukang
 * @date 2023/6/25 11:29 AM
 */
@AdvancedFeignClient
public interface RemoteExchangeEquityService {



    /**
     * 分页查询
     * @param param 分页参数
     * @return left：总条数，right：立减金
     */
    List<ExchangeEquityDto> selectPage(ExchangeEquitySearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 兑换权益
     */
    ExchangeEquityDto selectById(Long id);

    /**
     * 根据主键批量查询
     * @param ids 主键集合
     * @return 兑换权益列表
     */
    List<ExchangeEquityDto> selectByIds(List<Long> ids);

    /**
     * 查询所有的未删除的兑换权益
     * @return 兑换权益列表
     */
    List<ExchangeEquityDto> selectAllNotDeleteList();

    /**
     * 新增
     * @param entity 兑换权益
     * @return 执行结果
     */
    int insert(ExchangeEquityDto entity);

    /**
     * 更新
     * @param entity 兑换权益
     * @return 执行结果
     */
    int update(ExchangeEquityDto entity);
}
