package cn.com.duiba.duixintong.center.api.dto.card;

import cn.com.duiba.duixintong.center.api.enums.order.BankOrderGrantStautsEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
* 银行卡申请订单表
*/
@Data
public class BankCardOrderDto implements Serializable {

    private static final long serialVersionUID = -1334017522648768379L;
    /**
    * id
    */
    private Long id;

    /**
    * 用户id
    */
    private Long userId;

    /**
    * 推荐人用户id
    */
    private Long referenceUserId;

    /**
    * 商家ID
    */
    private Long businessId;

    /**
    * 活动ID
    */
    private Long activityId;

    /**
    * 银行ID
    */
    private Long bankId;

    /**
    * 渠道：
    */
    private Integer bankChannel;

    /**
    * 订单编号,唯一
    */
    private String orderNum;

    /**
    * 订单最新状态 1-创建，2-进件失败，3-进件成功，4-核批，5-拒批
     * @see cn.com.duiba.duixintong.center.api.enums.order.BankCardOrderEnum
    */
    private Integer cardStatus;

    /**
    * 发放状态  1，拒绝发放  2-发放
     * @see BankOrderGrantStautsEnum
    */
    private Integer grantStatus;

    /**
     * 发放账号
     */
    private String grantAccount;

    /**
    * 原因及明细
    */
    private String grantReason;

    /**
    * 最新银行回调信息字段
    */
    private String bankCallbackInfo;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;

    /**
     * 是否新用户
     */
    private Integer isNewUser;

}

