package cn.com.duiba.duixintong.center.api.dto.customer;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 客户
 * @author lizhi
 * @date 2023/5/31 4:09 PM
 */
@Data
public class DimensionCustomerDto implements Serializable {
    
    private static final long serialVersionUID = -719831903934146727L;
    
    /**
     * id
     */
    private Long id;

    /**
     * 统计维度对应的组合ID, 以英文逗号分隔
     */
    private String combinationId;

    /**
     * 统计维度：1-商家维度，2-商家+推荐人维度，3-商家+活动维度，4-商家+推荐人+活动维度
     * {@link cn.com.duiba.duixintong.center.api.enums.statistics.DimensionStatisticsEnum}
     */
    private Integer statDimension;

    /**
     * 推荐人用户id
     */
    private Long referenceUserId;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}
