package cn.com.duiba.duixintong.center.api.dto.equity;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
* 权益配置
*/
@Data
public class EquityDto implements Serializable {

    private static final long serialVersionUID = -4278380630810049297L;

    /**
    * 主键
    */
    private Long id;

    /**
    * 权益类型：1-微信立减金
     * @see cn.com.duiba.duixintong.center.api.enums.equity.EquityTypeEnum
    */
    private Integer equityType;

    /**
    * 银行ID
    */
    private Long bankId;

    /**
     * 银行名称
     */
    private String bankName;

    /**
    * 权益名称
    */
    private String equityName;

    /**
     * 发放数量
     */
    private Integer offerNum;

    /**
     * 有效期
     */
    private String expirationDate;

    /**
    * 权益图片
    */
    private String equityImg;

    /**
    * 详细说明
    */
    private String equityDesc;

    /**
    * 是否逻辑删除, 0-未删除, 1-已删除
    */
    private Integer logicDelete;

    /**
     * 扩展字段
     */
    private List<EquityExtDto> extList;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;

    /**
     * 渠道
     * @see cn.com.duiba.duixintong.center.api.enums.business.BankChannelEnum
     */
    private Integer channelType;

    /**
     * 权益开始时间
     */
    private String equityStartTime;

    /**
     * 权益结束时间
     */
    private String equityEndTime;

    /**
     * 售价(分)
     */
    private Long salePrice;
}

