package cn.com.duiba.duixintong.center.api.dto.fund;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 资金账户表
 * @author kjj mybatis generator 
 * @date 2023-06-06
 */
@Data
public class FundAccountDto implements Serializable {
     
    private static final long serialVersionUID = 16860428527916733L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 账户ID，推荐人ID(账户类型-1)，商家ID(账户类型-2)，重客ID(账户类型-3)
     */
    private Long accountId;

    /**
     * 账户类型，1-推荐人，2-商家，3-重客
     * {@link cn.com.duiba.duixintong.center.api.enums.fund.FundAccountTypeEnum}
     */
    private Integer accountType;

    /**
     * 累计收益(分)
     */
    private Long income;

    /**
     * 余额(分)
     */
    private Long balance;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}