package cn.com.duiba.duixintong.center.api.remoteservice.card;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duixintong.center.api.dto.card.BankCardOrderDto;
import cn.com.duiba.duixintong.center.api.dto.card.UserCardOrderDetailDto;
import cn.com.duiba.duixintong.center.api.dto.card.UserCardOrderDto;
import cn.com.duiba.duixintong.center.api.param.card.CardOrderParams;
import cn.com.duiba.duixintong.center.api.param.card.CardPageQueryParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

@AdvancedFeignClient
public interface RemoteBankCardOrderService {

    boolean save(BankCardOrderDto bankCardOrderDto);

    boolean updateById(BankCardOrderDto bankCardOrderDto);

    BankCardOrderDto getById(Long id);

    List<BankCardOrderDto> listByIds(List<Long> ids);

    List<BankCardOrderDto> queryByParams(CardOrderParams cardOrderParams);

    /**
     * 订单分页查询
     * @param param
     * @return
     */
    PageResponse<UserCardOrderDto> pageByParam(CardPageQueryParam param);

    /**
     * 订单详情
     * @param orderNum
     * @return
     */
    UserCardOrderDetailDto getOrderDetailByOrderNum(String orderNum);
}
