package cn.com.duiba.duixintong.center.api.param.order;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 办卡订单通用查询参数
 * @author lizhi
 * @date 2023/5/30 6:19 PM
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class BankCardOrderPageQueryParam extends PageRequest {
    
    private static final long serialVersionUID = 856749952771503236L;

    /**
     * 商家ID
     */
    private Long businessId;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 推荐人ID
     */
    private Long referenceUserId;

    /**
     * 办卡状态
     * {@link cn.com.duiba.duixintong.center.api.enums.order.BankCardOrderEnum}
     */
    private Integer cardStatus;

    /**
     * 查询开始时间
     */
    private Long startTime;

    /**
     * 查询截止时间
     */
    private Long endTime;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 订单号精确查询
     */
    private String orderNum;

    /**
     * 用户昵称分词查询
     */
    private String nickNameMatch;
}
