package cn.com.duiba.duixintong.center.api.remoteservice.fund;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duixintong.center.api.dto.fund.FundAccountDto;
import cn.com.duiba.duixintong.center.api.param.fund.DivideCodmmissionParam;
import cn.com.duiba.duixintong.center.api.param.fund.FundAccountChangeParam;

/**
 * 资金账户表 服务类
 * @author lizhi
 * @date 2023/6/8 7:24 PM
 */
@AdvancedFeignClient
public interface RemoteFundAccountService {

    /**
     * 根据主键查询
     * @param accountId 账户ID，推荐人ID(账户类型-1)，商家ID(账户类型-2)，重客ID(账户类型-3)
     * @param accountType 账户类型，1-推荐人，2-商家，3-重客
     * {@link cn.com.duiba.duixintong.center.api.enums.fund.FundAccountTypeEnum}
     * @return 资金账户
     */
    FundAccountDto selectByAccount(Long accountId, Integer accountType);


    /**
     * 首刷分佣
     * @param param 变更参数
     * @throws BizException 失败时抛出异常
     */
    void divideCodmmission(DivideCodmmissionParam param) throws BizException;
}
