package cn.com.duiba.duixintong.center.api.remoteservice.order;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duixintong.center.api.dto.es.BankCardOrderEsDto;
import cn.com.duiba.duixintong.center.api.dto.statistics.DimensionStatDto;
import cn.com.duiba.duixintong.center.api.param.order.BankCardOrderCommonParam;
import cn.com.duiba.duixintong.center.api.param.order.BankCardOrderCommonQueryParam;

import java.util.List;

/**
 * 办卡订单通用服务
 * @author lizhi
 * @date 2023/5/30 6:16 PM
 */
@AdvancedFeignClient
public interface RemoteBankCardOrderCommonService {

    /**
     * 查询实时列表
     * @param param 查询参数
     * @return 列表
     */
    List<BankCardOrderEsDto> selectRealList(BankCardOrderCommonQueryParam param);

    /**
     * 查询累计列表
     * @param param 查询参数
     * @return 列表
     */
    List<BankCardOrderEsDto> selectList(BankCardOrderCommonQueryParam param);


    /**
     * 查询统计数据
     * @param param 查询参数
     * @return 统计数据
     */
    DimensionStatDto selectStat(BankCardOrderCommonParam param);

    /**
     * 查询趋势图所需数据
     * @param param 查询参数
     * @return 统计数据集合
     */
    List<DimensionStatDto> selectTrendList(BankCardOrderCommonParam param);
}
