package cn.com.duiba.duixintong.center.api.dto.es;

import io.searchbox.annotations.JestId;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * 商家
 * @author lizhi
 * @date 2023/6/5 7:26 PM
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class BusinessEsDto extends BaseEsDto {
    
    private static final long serialVersionUID = -6625723782233384126L;

    /**
     * 主键
     */
    @JestId
    private Long id;

    /**
     * 商家名称
     */
    private String businessName;

    /**
     * 银行ID
     */
    private Long bankId;

    /**
     * 渠道：1-产险，2-车险，3-寿险，4-直销
     * @see cn.com.duiba.duixintong.center.api.enums.business.BankChannelEnum
     */
    private Integer bankChannel;

    /**
     * 商家状态:0-停用，1-启用
     * {@link cn.com.duiba.duixintong.center.api.enums.BooleanEnum}
     */
    private Integer businessStatus;

    /**
     * 创建时间
     */
    private Long gmtCreate;
}
