package cn.com.duiba.duixintong.center.api.dto.order;

import cn.com.duiba.duixintong.center.api.enums.order.BankCardOrderEnum;
import cn.com.duiba.duixintong.center.api.enums.order.EquityOrderStautsEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
* 用户权益发放状态变更记录表
*/
@Data
public class UserEquityStatusRecordDto implements Serializable {

    private static final long serialVersionUID = 2263785831512253802L;

    /**
    * id
    */
    private Long id;

    /**
    * 领取权益的id
    */
    private Long userEquityId;

    /**
     * 权益id
     */
    private Long equityId;

    /**
    * 状态 1-创建 2-发放中，3-发放成功，4发放失败，5核销
     * @see EquityOrderStautsEnum
    */
    private Integer status;

    /**
    * 信息详情
    */
    private String callbackInfo;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 推荐人用户id
     */
    private Long referenceUserId;

    /**
     * 商家ID
     */
    private Long businessId;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 银行ID
     */
    private Long bankId;

    /**
     * 渠道
     * @see cn.com.duiba.duixintong.center.api.enums.business.BankChannelEnum
     */
    private Integer bankChannel;

    /**
     * 关联的专员ID，对应tb_commissioner.id
     */
    private Long commissionerId;

    /**
     * 关联的重客ID，对应tb_important_customer.id
     */
    private Long importantCustomerId;
}

