package cn.com.duiba.duixintong.center.api.remoteservice.commissioner;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duixintong.center.api.dto.commissioner.CommissionerDto;

/**
 * 专员
 * @author lizhi
 * @date 2023/6/28 4:39 PM
 */
@AdvancedFeignClient
public interface RemoteCommissionerService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 专员
     */
    CommissionerDto selectById(Long id);

    /**
     * 根据用户查询查询
     * @param userId 用户ID
     * @return 专员
     */
    CommissionerDto selectByUserId(Long userId);

    /**
     * 根据银行scc码查询
     * @param bankScc 银行scc码
     * @return 专员
     */
    CommissionerDto selectByScc(String bankScc);

    /**
     * 根据工号查询
     * @param jobNum 工号
     * @return 专员
     */
    CommissionerDto selectByJobNum(String jobNum);

    /**
     * 新增
     * @param dto 专员
     * @return 执行结果
     */
    int insert(CommissionerDto dto);
}
