package cn.com.duiba.duixintong.center.api.remoteservice.fund;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duixintong.center.api.dto.fund.FundAccountChangeRecordDto;
import cn.com.duiba.duixintong.center.api.param.fund.FundAccountChangeRecordParam;

import java.util.List;

/**
 * 资金账户流水表 服务类
 * @author lizhi
 * @date 2023/6/8 7:45 PM
 */
@AdvancedFeignClient
public interface RemoteFundAccountChangeRecordService {

    /**
     * 根据流水记录号查询
     * @param detailNo 流水记录号
     * @return 资金账户流水
     */
    FundAccountChangeRecordDto selectByDetailNo(String detailNo);

    /**
     * 分页查询
     * @param param 查询参数
     * @return 资金账户流水集合
     */
    List<FundAccountChangeRecordDto> selectPage(FundAccountChangeRecordParam param);
}
