package cn.com.duiba.duixintong.center.api.remoteservice.reference;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duixintong.center.api.dto.reference.ReferenceRelatedBankInfoDto;
import cn.com.duiba.duixintong.center.api.dto.reference.ReferenceRelatedDto;
import cn.com.duiba.duixintong.center.api.param.reference.ReferencePageQueryParam;

import java.util.List;

/**
 * 推荐人商家关联
 * @author lizhi
 * @date 2023/5/21 4:25 PM
 */
@AdvancedFeignClient
public interface RemoteReferenceRelatedService {

    /**
     * 根据唯一键查询
     * @param userId 用户ID
     * @param businessId 商家ID
     * @return 推荐人商家关联
     */
    ReferenceRelatedDto selectByUk(Long userId, Long businessId);

    /**
     * 查询当前用户加入的银行和渠道
     * @param userId 用户ID
     * @return 加入的所有银行和渠道
     */
    List<ReferenceRelatedBankInfoDto> selectBankByUserId(Long userId);

    /**
     * 分页查询推荐人列表
     * @param param 分页参数
     * @return 推荐人列表
     */
    List<ReferenceRelatedDto> listByParam(ReferencePageQueryParam param);

    /**
     * 新增或更新
     * @param dto 推荐人商家关联
     * @return 执行结果
     */
    int saveOrUpdate(ReferenceRelatedDto dto);
}
