package cn.com.duiba.duixintong.center.api.dto.statistics;

import lombok.Data;

import java.io.Serializable;

/**
 * 统计数据
 * @author lizhi
 * @date 2023/5/28 4:06 PM
 */
@Data
public class DimensionStatDto implements Serializable {
    
    private static final long serialVersionUID = -9105128642071630259L;

    /**
     * 维度时间类型
     * {@link cn.com.duiba.duixintong.center.api.enums.statistics.DimensionStatTimeTypeEnum}
     */
    private Integer type;

    /**
     * 所属维度时间
     */
    private Long statTime;

    /**
     * 统计维度对应的组合ID, 以英文逗号分隔
     */
    private String combinationId;

    /**
     * 统计维度：1-商家维度，2-商家+推荐人维度，3-商家+活动维度，4-商家+推荐人+活动维度
     */
    private Integer statDimension;

    /**
     * 推荐人数量
     */
    private Long referenceNum = 0L;

    /**
     * 客户数
     */
    private Long userNum = 0L;

    /**
     * 订单数（总订单流水数）
     */
    private Long orderNum = 0L;

    /**
     * 进件数
     */
    private Long applyNum = 0L;

    /**
     * 核批数
     */
    private Long approvalNum = 0L;

    /**
     * 拒批数
     */
    private Long rejectNum = 0L;

    /**
     * 权益发放成功数量
     */
    private Long equitySuccessNum = 0L;

    /**
     * 权益核销数量
     */
    private Long equityVerificationNum = 0L;

    /**
     * 激活数
     */
    private Long activatedNum = 0L;

    /**
     * 首刷数
     */
    private Long firstUsedNum = 0L;
}
