package cn.com.duiba.duixintong.center.api.dto.withdraw;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 提现用户表
 * @author kjj mybatis generator 
 * @date 2023-06-19
 */
@Data
public class WithdrawUserDto implements Serializable {
     
    private static final long serialVersionUID = 16871657736635545L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 账户ID，推荐人ID(账户类型-1)，商家ID(账户类型-2)，重客ID(账户类型-3)
     */
    private Long accountId;

    /**
     * 账户类型，1-推荐人，2-商家，3-重客
     * @see cn.com.duiba.duixintong.center.api.enums.fund.FundAccountTypeEnum
     */
    private Integer accountType;

    /**
     * 提现用户ID，对应tb_users.id
     */
    private Long userId;

    /**
     * 提现用户姓名
     */
    private String userName;

    /**
     * 提现用户编辑时验证的手机号
     */
    private String userPhone;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}