package cn.com.duiba.duixintong.center.api.enums.activity;

import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * @author: pengyi
 * @description:
 * @date: 2023/5/17 10:31
 */
public enum ActivityStatusEnum {
    OFF(0, "停用"),
    ON(1, "启用"),
    ;

    private Integer code;
    private String desc;

    ActivityStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ActivityStatusEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        ActivityStatusEnum[] values = ActivityStatusEnum.values();
        for (ActivityStatusEnum value : values) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
